/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.jackrabbit.oak.segment.ImmutableRecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.data.SegmentData;
import org.jetbrains.annotations.NotNull;

public interface RecordNumbers
extends Iterable<Entry> {
    public static final RecordNumbers EMPTY_RECORD_NUMBERS = new RecordNumbers(){

        @Override
        public int getOffset(int recordNumber) {
            return -1;
        }

        @Override
        @NotNull
        public Iterator<Entry> iterator() {
            return Collections.emptyIterator();
        }
    };

    @NotNull
    public static RecordNumbers fromSegmentData(@NotNull SegmentData data) {
        int recordNumberCount = data.getRecordReferencesCount();
        if (recordNumberCount == 0) {
            return EMPTY_RECORD_NUMBERS;
        }
        int maxIndex = data.getRecordReferenceNumber(recordNumberCount - 1);
        byte[] types = new byte[maxIndex + 1];
        int[] offsets = new int[maxIndex + 1];
        Arrays.fill(offsets, -1);
        for (int i = 0; i < recordNumberCount; ++i) {
            int recordNumber = data.getRecordReferenceNumber(i);
            types[recordNumber] = data.getRecordReferenceType(i);
            offsets[recordNumber] = data.getRecordReferenceOffset(i);
        }
        return new ImmutableRecordNumbers(offsets, types);
    }

    public int getOffset(int var1);

    public static interface Entry {
        public int getRecordNumber();

        public int getOffset();

        public RecordType getType();
    }
}

