/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameters;
import org.silverpeas.core.persistence.datasource.repository.jpa.SilverpeasJpaEntityRepository;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.user.ReplacementEventNotifier;
import org.silverpeas.core.workflow.engine.user.ReplacementImpl;
import org.silverpeas.kernel.logging.SilverLogger;

@Repository
public class ReplacementRepository
extends SilverpeasJpaEntityRepository<ReplacementImpl>
implements Replacement.Repository {
    private static final String WORKFLOW_PARAM = "workflow";
    private static final String SUBSTITUTE_PARAM = "substitute";
    private static final String INCUMBENT_PARAM = "incumbent";
    @Inject
    private ReplacementEventNotifier notifier;

    @Override
    public <T extends Replacement<T>> T save(Replacement<T> replacement) {
        ReplacementImpl previous = (ReplacementImpl)Transaction.performInNew(() -> {
            if (replacement.getId() != null) {
                return this.findById(replacement.getId());
            }
            return null;
        });
        ReplacementImpl saved = (ReplacementImpl)super.save((IdentifiableEntity)((ReplacementImpl)replacement));
        if (previous != null) {
            this.notifyUsers(ResourceEvent.Type.UPDATE, previous, saved);
        } else {
            this.notifyUsers(ResourceEvent.Type.CREATION, saved);
        }
        return (T)saved;
    }

    @Override
    public <T extends Replacement<T>> void delete(Replacement<T> replacement) {
        super.delete((IdentifiableEntity[])new ReplacementImpl[]{(ReplacementImpl)replacement});
        this.notifyUsers(ResourceEvent.Type.DELETION, replacement);
    }

    public List<ReplacementImpl> findAllByIncumbentAndByWorkflow(User user, String workflowInstanceId) {
        NamedParameters parameters = this.newNamedParameters().add(INCUMBENT_PARAM, (Object)user.getUserId()).add(WORKFLOW_PARAM, (Object)workflowInstanceId);
        return this.findByNamedQuery("Replacement.findAllByIncumbentAndByWorkflow", parameters);
    }

    public List<ReplacementImpl> findAllBySubstituteAndByWorkflow(User user, String workflowInstanceId) {
        NamedParameters parameters = this.newNamedParameters().add(SUBSTITUTE_PARAM, (Object)user.getUserId()).add(WORKFLOW_PARAM, (Object)workflowInstanceId);
        return this.findByNamedQuery("Replacement.findAllBySubstituteAndByWorkflow", parameters);
    }

    public List<ReplacementImpl> findAllByWorkflow(String workflowInstanceId) {
        NamedParameters parameters = this.newNamedParameters().add(WORKFLOW_PARAM, (Object)workflowInstanceId);
        return this.findByNamedQuery("Replacement.findAllByWorkflow", parameters);
    }

    public List<ReplacementImpl> findAllByUsersAndByWorkflow(User incumbent, User substitute, String workflowInstanceId) {
        NamedParameters parameters = this.newNamedParameters().add(INCUMBENT_PARAM, (Object)incumbent.getUserId()).add(SUBSTITUTE_PARAM, (Object)substitute.getUserId()).add(WORKFLOW_PARAM, (Object)workflowInstanceId);
        return this.findByNamedQuery("Replacement.findAllByUsersAndByWorkflow", parameters);
    }

    public ReplacementImpl findById(String replacementId) {
        return (ReplacementImpl)super.getById(replacementId);
    }

    private void notifyUsers(ResourceEvent.Type cause, Replacement<?> ... replacements) {
        try {
            this.notifier.notifyEventOn(cause, (Serializable[])replacements);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }
}

