/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.notification;

import java.util.Collection;
import java.util.List;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.DataRecordUtil;
import org.silverpeas.core.notification.user.FallbackToCoreTemplatePathBehavior;
import org.silverpeas.core.notification.user.builder.AbstractTemplateUserNotificationBuilder;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.util.Link;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class UserNotificationBuilder
extends AbstractTemplateUserNotificationBuilder<Task>
implements FallbackToCoreTemplatePathBehavior {
    private static final String MULTILANG_BUNDLE = "org.silverpeas.workflow.multilang.usernotification";
    private List<String> userIds;
    private final User sender;
    private final String text;
    private final boolean linkDisabled;
    private final String incumbentId;

    public UserNotificationBuilder(List<String> userIds, Task task, User sender, String text, boolean linkDisabled, String incumbentId) {
        super((Object)task);
        this.userIds = userIds;
        this.sender = sender;
        this.text = text;
        this.linkDisabled = linkDisabled;
        this.incumbentId = incumbentId;
    }

    protected void performTemplateData(String language, Task task, SilverpeasTemplate template) {
        ProcessInstance processInstance = task.getProcessInstance();
        this.getNotificationMetaData().addLanguage(language, processInstance.getTitle(task.getUserRoleName(), language), null);
        if (!this.linkDisabled) {
            String link = "/RprocessManager/" + processInstance.getModelId() + "/searchResult?Type=ProcessInstance&Id=" + processInstance.getInstanceId() + "&role=" + task.getUserRoleName();
            if (StringUtil.isDefined((String)this.incumbentId)) {
                link = link + "&IncumbentId=" + this.incumbentId;
            }
            this.getNotificationMetaData().setLink(new Link(link, this.getBundle(language).getString("notification.notifLinkLabel")), language);
        }
        try {
            DataRecord data = task.getProcessInstance().getAllDataRecord(task.getUserRoleName(), language);
            String content = DataRecordUtil.applySubstitution((String)this.text, (DataRecord)data, (String)language);
            template.setAttribute("content", (Object)content);
        }
        catch (WorkflowException e) {
            SilverLogger.getLogger((Object)((Object)this)).error(e.getMessage(), (Throwable)((Object)e));
        }
    }

    protected void performNotificationResource(String language, Task task, NotificationResourceData notificationResourceData) {
        notificationResourceData.setFeminineGender(true);
        notificationResourceData.setResourceName(task.getProcessInstance().getTitle(task.getUserRoleName(), language));
    }

    protected String getTemplatePath() {
        return "workflow";
    }

    protected String getTemplateFileName() {
        return "notification";
    }

    protected String getComponentInstanceId() {
        return ((Task)this.getResource()).getProcessInstance().getModelId();
    }

    protected String getSender() {
        if (this.sender != null) {
            return this.sender.getUserId();
        }
        return null;
    }

    protected Collection<String> getUserIdsToNotify() {
        return this.userIds;
    }

    protected String getLocalizationBundlePath() {
        return MULTILANG_BUNDLE;
    }

    protected String getContributionAccessLinkLabelBundleKey() {
        return "notification.notifLinkLabel";
    }

    protected NotifAction getAction() {
        return NotifAction.REPORT;
    }
}

