/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.contribution.content.form.FieldTemplate;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.RecordSet;
import org.silverpeas.core.contribution.content.form.RecordTemplate;
import org.silverpeas.core.contribution.content.form.dummy.DummyRecordSet;
import org.silverpeas.core.contribution.content.form.form.HtmlForm;
import org.silverpeas.core.contribution.content.form.form.XmlForm;
import org.silverpeas.core.contribution.content.form.record.GenericFieldTemplate;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSet;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.contribution.content.form.record.GenericRecordTemplate;
import org.silverpeas.core.contribution.content.form.record.IdentifiedRecordTemplate;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Actions;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.DataFolder;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.Forms;
import org.silverpeas.core.workflow.api.model.Participant;
import org.silverpeas.core.workflow.api.model.Participants;
import org.silverpeas.core.workflow.api.model.Presentation;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.api.model.RelatedUser;
import org.silverpeas.core.workflow.api.model.Role;
import org.silverpeas.core.workflow.api.model.Roles;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.States;
import org.silverpeas.core.workflow.api.model.UserInRole;
import org.silverpeas.core.workflow.engine.WorkflowHub;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceRecordTemplate;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceRowTemplate;
import org.silverpeas.core.workflow.engine.model.ActionsImpl;
import org.silverpeas.core.workflow.engine.model.DataFolderImpl;
import org.silverpeas.core.workflow.engine.model.FormImpl;
import org.silverpeas.core.workflow.engine.model.FormsImpl;
import org.silverpeas.core.workflow.engine.model.ParticipantsImpl;
import org.silverpeas.core.workflow.engine.model.PresentationImpl;
import org.silverpeas.core.workflow.engine.model.QualifiedUsersImpl;
import org.silverpeas.core.workflow.engine.model.RelatedUserImpl;
import org.silverpeas.core.workflow.engine.model.RolesImpl;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;
import org.silverpeas.core.workflow.engine.model.StatesImpl;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(name="processModel")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ProcessModelImpl
implements ProcessModel,
Serializable {
    private static final long serialVersionUID = -4576686557632464607L;
    private static final String PROCESS_MODEL = "ProcessModel";
    private String modelId;
    @XmlAttribute
    private String name;
    @XmlElement(name="label", type=SpecificLabel.class)
    private List<ContextualDesignation> labels;
    @XmlElement(name="description", type=SpecificLabel.class)
    private List<ContextualDesignation> descriptions;
    @XmlElement(type=RolesImpl.class)
    private Roles roles;
    @XmlElement(type=PresentationImpl.class)
    private Presentation presentation;
    @XmlElement(type=ParticipantsImpl.class)
    private Participants participants;
    @XmlElement(type=StatesImpl.class)
    private States states;
    @XmlElement(type=ActionsImpl.class)
    private Actions actions;
    @XmlElement(type=DataFolderImpl.class)
    private DataFolder dataFolder;
    @XmlElement(type=DataFolderImpl.class)
    private DataFolder userInfos;
    @XmlElement(type=FormsImpl.class)
    private Forms forms;
    private final HashMap<String, RecordTemplate> instanceDataTemplates = new HashMap();
    private final HashMap<String, RecordTemplate> rowTemplates = new HashMap();

    public ProcessModelImpl() {
        this.labels = new ArrayList<ContextualDesignation>();
        this.descriptions = new ArrayList<ContextualDesignation>();
        this.presentation = this.createPresentation();
        this.dataFolder = new DataFolderImpl();
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    @Override
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Presentation getPresentation() {
        return this.presentation;
    }

    @Override
    public void setPresentation(Presentation presentation) {
        this.presentation = presentation;
    }

    @Override
    public Presentation createPresentation() {
        return new PresentationImpl();
    }

    @Override
    public Participant[] getParticipants() {
        if (this.participants == null) {
            return new Participant[0];
        }
        return this.participants.getParticipants();
    }

    @Override
    public Participants getParticipantsEx() {
        return this.participants;
    }

    @Override
    public void setParticipants(Participants participants) {
        this.participants = participants;
    }

    @Override
    public Participants createParticipants() {
        return new ParticipantsImpl();
    }

    @Override
    public Role[] getRoles() {
        if (this.roles == null) {
            return new Role[0];
        }
        return this.roles.getRoles();
    }

    @Override
    public Role getRole(String name) {
        if (this.roles == null) {
            return null;
        }
        return this.roles.getRole(name);
    }

    @Override
    public Roles getRolesEx() {
        return this.roles;
    }

    @Override
    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    @Override
    public Roles createRoles() {
        return new RolesImpl();
    }

    @Override
    public State[] getStates() {
        if (this.states == null) {
            return new State[0];
        }
        return this.states.getStates();
    }

    @Override
    public States getStatesEx() {
        return this.states;
    }

    @Override
    public State getState(String name) {
        if (this.states == null) {
            return null;
        }
        return this.states.getState(name);
    }

    @Override
    public void setStates(States states) {
        this.states = states;
    }

    @Override
    public States createStates() {
        return new StatesImpl();
    }

    @Override
    public Action[] getActions() {
        if (this.actions == null) {
            return new Action[0];
        }
        return this.actions.getActions();
    }

    @Override
    public Actions getActionsEx() {
        return this.actions;
    }

    @Override
    public Action getAction(String name) throws WorkflowException {
        if (this.actions == null) {
            return null;
        }
        return this.actions.getAction(name);
    }

    @Override
    public void setActions(Actions actions) {
        this.actions = actions;
    }

    @Override
    public Actions createActions() {
        return new ActionsImpl();
    }

    @Override
    public DataFolder getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public void setDataFolder(DataFolder dataFolder) {
        this.dataFolder = dataFolder;
    }

    @Override
    public DataFolder createDataFolder() {
        return new DataFolderImpl();
    }

    @Override
    public DataFolder getUserInfos() {
        return this.userInfos;
    }

    @Override
    public void setUserInfos(DataFolder userInfos) {
        this.userInfos = userInfos;
    }

    @Override
    public Forms getForms() {
        return this.forms;
    }

    @Override
    public Form getForm(String name) {
        return this.getForm(name, null);
    }

    @Override
    public Form getForm(String name, String role) {
        if (this.forms == null) {
            return null;
        }
        return this.forms.getForm(name, role);
    }

    @Override
    public void setForms(Forms forms) {
        this.forms = forms;
    }

    @Override
    public Forms createForms() {
        return new FormsImpl();
    }

    @Override
    public ContextualDesignations getLabels() {
        return new SpecificLabelListHelper(this.labels);
    }

    @Override
    public String getLabel(String role, String language) {
        return this.getLabels().getLabel(role, language);
    }

    @Override
    public ContextualDesignations getDescriptions() {
        return new SpecificLabelListHelper(this.descriptions);
    }

    @Override
    public String getDescription(String role, String language) {
        return this.getDescriptions().getLabel(role, language);
    }

    @Override
    public QualifiedUsers createQualifiedUsers() {
        return new QualifiedUsersImpl();
    }

    @Override
    public RelatedUser createRelatedUser() {
        return new RelatedUserImpl();
    }

    @Override
    public String getFolderRecordSetName() {
        return this.modelId + ":folder";
    }

    @Override
    public String getFormRecordSetName(String formName) {
        return this.modelId + ":form:" + formName;
    }

    @Override
    public RecordSet getFolderRecordSet() throws WorkflowException {
        int templateId;
        IdentifiedRecordTemplate idTemplate;
        try {
            RecordSet recordSet = this.getGenericRecordSetManager().getRecordSet(this.getFolderRecordSetName());
            idTemplate = (IdentifiedRecordTemplate)recordSet.getRecordTemplate();
            templateId = idTemplate.getInternalId();
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_MODEL, "workflowEngine.EXP_UNKNOWN_RECORD_SET", this.getFolderRecordSetName(), (Exception)((Object)e));
        }
        RecordTemplate template = this.dataFolder.toRecordTemplate(null, null, false);
        idTemplate = new IdentifiedRecordTemplate(template);
        idTemplate.setExternalId(this.getFolderRecordSetName());
        idTemplate.setInternalId(templateId);
        return new GenericRecordSet(idTemplate);
    }

    @Override
    public RecordSet getFormRecordSet(String formName) throws WorkflowException {
        try {
            FieldTemplate[] fields;
            RecordSet recordSet = this.getGenericRecordSetManager().getRecordSet(this.getFormRecordSetName(formName));
            if (recordSet instanceof DummyRecordSet) {
                Form form = this.getForm(formName);
                RecordTemplate template = form.toRecordTemplate(null, null);
                this.getGenericRecordSetManager().createRecordSet(this.getFormRecordSetName(formName), template);
                recordSet = this.getGenericRecordSetManager().getRecordSet(this.getFormRecordSetName(formName));
            }
            IdentifiedRecordTemplate template = (IdentifiedRecordTemplate)recordSet.getRecordTemplate();
            GenericRecordTemplate wrapped = (GenericRecordTemplate)template.getWrappedTemplate();
            FormImpl form = (FormImpl)this.getForm(formName);
            for (FieldTemplate field : fields = form.toRecordTemplate(null, null).getFieldTemplates()) {
                String fieldName = field.getFieldName();
                String fieldType = field.getTypeName();
                boolean isMandatory = field.isMandatory();
                boolean isReadOnly = field.isReadOnly();
                boolean isHidden = field.isHidden();
                GenericFieldTemplate fieldTemplate = new GenericFieldTemplate(fieldName, fieldType);
                fieldTemplate.setMandatory(isMandatory);
                fieldTemplate.setReadOnly(isReadOnly);
                fieldTemplate.setHidden(isHidden);
                wrapped.addFieldTemplate((FieldTemplate)fieldTemplate);
            }
            return recordSet;
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_MODEL, "workflowEngine.EXP_UNKNOWN_RECORD_SET", this.getFormRecordSetName(formName), (Exception)((Object)e));
        }
    }

    @Override
    public Form getActionForm(String actionName) throws WorkflowException {
        Action action = this.getAction(actionName);
        return action.getForm();
    }

    @Override
    public Action getCreateAction(String role) throws WorkflowException {
        Action[] someActions;
        for (Action action : someActions = this.getActions()) {
            UserInRole[] usersInRoles;
            if (!"create".equals(action.getKind())) continue;
            QualifiedUsers creators = action.getAllowedUsers();
            for (UserInRole usersInRole : usersInRoles = creators.getUserInRoles()) {
                if (!role.equals(usersInRole.getRoleName())) continue;
                return action;
            }
        }
        throw new WorkflowException(PROCESS_MODEL, "workflowEngine.ERR_NO_CREATE_ACTION_DEFINED");
    }

    @Override
    public org.silverpeas.core.contribution.content.form.Form getPublicationForm(String actionName, String roleName, String lang) throws WorkflowException {
        Action action = this.getAction(actionName);
        if (action == null || action.getForm() == null) {
            return null;
        }
        return this.getConcreteForm(action.getForm(), roleName, lang, false);
    }

    @Override
    public org.silverpeas.core.contribution.content.form.Form getPresentationForm(String name, String roleName, String lang) throws WorkflowException {
        Form form;
        Action action = null;
        if (!"presentationForm".equalsIgnoreCase(name)) {
            try {
                action = this.getAction(name);
            }
            catch (WorkflowException e) {
                SilverLogger.getLogger((Object)this).warn(e.getMessage(), new Object[0]);
            }
        }
        if ((form = action != null ? action.getForm() : this.getForm(name, roleName)) == null) {
            return null;
        }
        return this.getConcreteForm(form, roleName, lang, true);
    }

    private org.silverpeas.core.contribution.content.form.Form getConcreteForm(Form form, String roleName, String lang, boolean readOnly) throws WorkflowException {
        try {
            if (StringUtil.isDefined((String)form.getHTMLFileName())) {
                HtmlForm htmlForm = new HtmlForm(form.toRecordTemplate(roleName, lang));
                htmlForm.setFileName(WorkflowHub.getProcessModelManager().getProcessModelDir() + form.getHTMLFileName());
                htmlForm.setName(form.getName());
                htmlForm.setTitle(form.getTitle(roleName, lang));
                return htmlForm;
            }
            XmlForm xmlForm = new XmlForm(form.toRecordTemplate(roleName, lang, readOnly));
            xmlForm.setName(form.getName());
            xmlForm.setTitle(form.getTitle(roleName, lang));
            return xmlForm;
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_MODEL, "workflowEngine.EXP_ILL_FORMED_FORM", form.getName(), (Exception)((Object)e));
        }
    }

    @Override
    public DataRecord getNewActionRecord(String actionName, String roleName, String lang, DataRecord data) throws WorkflowException {
        Action action = this.getAction(actionName);
        if (action == null || action.getForm() == null) {
            return null;
        }
        return action.getForm().getDefaultRecord(roleName, lang, data);
    }

    @Override
    public DataRecord getNewUserInfosRecord(String roleName, String lang) throws WorkflowException {
        try {
            return this.getUserInfos().toRecordTemplate(roleName, lang, false).getEmptyRecord();
        }
        catch (FormException e) {
            throw new WorkflowException(PROCESS_MODEL, "workflowEngine.EXP_ILL_FORMED_FORM", "User Infos", (Exception)((Object)e));
        }
    }

    @Override
    public String[] getCreationRoles() throws WorkflowException {
        try {
            Action[] someActions;
            ArrayList<String> someRoles = new ArrayList<String>();
            for (Action action : someActions = this.getActions()) {
                UserInRole[] usersInRoles;
                if (!"create".equals(action.getKind())) continue;
                QualifiedUsers creators = action.getAllowedUsers();
                for (UserInRole usersInRole : usersInRoles = creators.getUserInRoles()) {
                    if (someRoles.contains(usersInRole.getRoleName())) continue;
                    someRoles.add(usersInRole.getRoleName());
                }
            }
            return someRoles.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new WorkflowException(PROCESS_MODEL, "workflowEngine.EXP_FAIL_GET_CREATION_ROLES", this.name, e);
        }
    }

    @Override
    public RecordTemplate getAllDataTemplate(String role, String lang) {
        RecordTemplate template = this.instanceDataTemplates.get(role + "\n" + lang);
        if (template == null) {
            template = new ProcessInstanceRecordTemplate(this, role, lang);
            this.instanceDataTemplates.put(role + "\n" + lang, template);
        }
        return template;
    }

    @Override
    public RecordTemplate getRowTemplate(String role, String lang) {
        RecordTemplate template = this.rowTemplates.get(role + "\n" + lang);
        if (template == null) {
            template = new ProcessInstanceRowTemplate(this, role, lang);
            this.rowTemplates.put(role + "\n" + lang, template);
        }
        return template;
    }

    @Override
    public RecordTemplate getRowTemplate(String role, String lang, boolean isProcessIdVisible) {
        RecordTemplate template = this.rowTemplates.get(role + "\n" + lang);
        if (template == null) {
            template = this.initRowTemplate(role, lang, isProcessIdVisible);
        } else {
            boolean isProcessIdVisibleField;
            FieldTemplate instanceIdField = null;
            try {
                instanceIdField = template.getFieldTemplate("instance.id");
            }
            catch (FormException formException) {
                // empty catch block
            }
            boolean bl = isProcessIdVisibleField = instanceIdField != null;
            if (!isProcessIdVisibleField && isProcessIdVisible || isProcessIdVisibleField && !isProcessIdVisible) {
                template = this.initRowTemplate(role, lang, isProcessIdVisible);
            }
        }
        return template;
    }

    private RecordTemplate initRowTemplate(String role, String lang, boolean isProcessIdVisible) {
        ProcessInstanceRowTemplate template = new ProcessInstanceRowTemplate(this, role, lang, isProcessIdVisible);
        this.rowTemplates.put(role + "\n" + lang, template);
        return template;
    }

    private GenericRecordSetManager getGenericRecordSetManager() {
        return GenericRecordSetManager.getInstance();
    }
}

