/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Consequence;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.model.StateSetter;
import org.silverpeas.core.workflow.api.model.Triggers;
import org.silverpeas.core.workflow.engine.model.QualifiedUsersImpl;
import org.silverpeas.core.workflow.engine.model.StateImpl;
import org.silverpeas.core.workflow.engine.model.StateRef;
import org.silverpeas.core.workflow.engine.model.TriggersImpl;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement(name="consequence")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ConsequenceImpl
implements Consequence {
    private static final long serialVersionUID = -905677587105320693L;
    @XmlAttribute
    private String item;
    @XmlAttribute
    private String operator;
    @XmlAttribute
    private String value;
    @XmlElement
    private boolean kill = false;
    @XmlElement(name="set", type=StateRef.class)
    private List<StateSetter> targetStateList = new Vector<StateSetter>();
    @XmlElement(name="unset", type=StateRef.class)
    private List<StateSetter> unsetStateList = new Vector<StateSetter>();
    @XmlElement(name="notify", type=QualifiedUsersImpl.class)
    private List<QualifiedUsers> notifiedUsersList = new ArrayList<QualifiedUsers>();
    @XmlElement(type=TriggersImpl.class)
    private Triggers triggers = new TriggersImpl();

    @Override
    public State getTargetState(String strStateName) {
        return this.getState(strStateName, this.targetStateList);
    }

    private State getState(String stateName, List<StateSetter> states) {
        for (StateSetter state : states) {
            if (!state.getState().getName().equals(stateName)) continue;
            return state.getState();
        }
        return null;
    }

    @Override
    public State[] getTargetStates() {
        return this.getStates(this.targetStateList);
    }

    private State[] getStates(List<StateSetter> stateSetters) {
        if (stateSetters == null) {
            return new State[0];
        }
        State[] states = new StateImpl[stateSetters.size()];
        for (int i = 0; i < stateSetters.size(); ++i) {
            StateRef ref = (StateRef)stateSetters.get(i);
            states[i] = ref.getState();
        }
        return states;
    }

    @Override
    public void addTargetState(StateSetter stateSetter) {
        this.targetStateList.add(stateSetter);
    }

    @Override
    public State getUnsetState(String strStateName) {
        return this.getState(strStateName, this.unsetStateList);
    }

    @Override
    public State[] getUnsetStates() {
        return this.getStates(this.unsetStateList);
    }

    @Override
    public void addUnsetState(StateSetter stateSetter) {
        this.unsetStateList.add(stateSetter);
    }

    @Override
    public boolean getKill() {
        return this.kill;
    }

    @Override
    public void setKill(boolean kill) {
        this.kill = kill;
    }

    @Override
    public List<QualifiedUsers> getNotifiedUsers() {
        return this.notifiedUsersList;
    }

    @Override
    public void setNotifiedUsers(List<QualifiedUsers> notifiedUsersList) {
        this.notifiedUsersList = notifiedUsersList;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isVerified(String itemValue) {
        if (this.getItem() == null && this.getOperator() == null && this.getValue() == null) {
            return true;
        }
        boolean processValueAsString = false;
        boolean processValueAsInt = StringUtil.isInteger((String)itemValue);
        int iValue = -9999;
        float fValue = -9999.0f;
        if (processValueAsInt) {
            iValue = Integer.parseInt(itemValue);
        } else if (StringUtil.isFloat((String)itemValue)) {
            fValue = Float.parseFloat(itemValue);
        } else {
            processValueAsString = true;
        }
        if (this.getValue() != null && this.getValue().isEmpty()) {
            processValueAsInt = false;
            processValueAsString = true;
        }
        return this.processOperator(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
    }

    private boolean processOperator(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if ("=".equals(this.getOperator())) {
            return this.processEquals(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if ("!=".equals(this.getOperator())) {
            return this.processInequals(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if (this.getOperator().equals(">")) {
            return this.processGreater(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if (this.getOperator().equals(">=")) {
            return this.processGreaterOrEquals(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if (this.getOperator().equals("<")) {
            return this.processLesser(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if (this.getOperator().equals("<=")) {
            return this.processLesserOrEquals(itemValue, processValueAsString, processValueAsInt, iValue, fValue);
        }
        if (this.getOperator().equals("contains")) {
            return this.processContains(itemValue, processValueAsString);
        }
        return false;
    }

    private boolean processContains(String itemValue, boolean processValueAsString) {
        if (processValueAsString) {
            return itemValue.contains(this.getValue());
        }
        return false;
    }

    private boolean processLesserOrEquals(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return itemValue.compareTo(this.getValue()) <= 0;
        }
        if (processValueAsInt) {
            return iValue <= this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) <= 0;
    }

    private boolean processLesser(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return itemValue.compareTo(this.getValue()) < 0;
        }
        if (processValueAsInt) {
            return iValue < this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) < 0;
    }

    private boolean processGreaterOrEquals(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return itemValue.compareTo(this.getValue()) >= 0;
        }
        if (processValueAsInt) {
            return iValue >= this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) >= 0;
    }

    private boolean processGreater(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return itemValue.compareTo(this.getValue()) > 0;
        }
        if (processValueAsInt) {
            return iValue > this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) > 0;
    }

    private boolean processInequals(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return !itemValue.equalsIgnoreCase(this.getValue());
        }
        if (processValueAsInt) {
            return iValue != this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) != 0;
    }

    private boolean processEquals(String itemValue, boolean processValueAsString, boolean processValueAsInt, int iValue, float fValue) {
        if (processValueAsString) {
            return itemValue.equalsIgnoreCase(this.getValue());
        }
        if (processValueAsInt) {
            return iValue == this.getValueAsInt();
        }
        return Float.compare(fValue, this.getValueAsFloat()) == 0;
    }

    private float getValueAsFloat() {
        return Float.parseFloat(this.getValue());
    }

    private int getValueAsInt() {
        return Integer.parseInt(this.getValue());
    }

    @Override
    public void setItem(String string) {
        this.item = string;
    }

    @Override
    public void setOperator(String string) {
        this.operator = string;
    }

    @Override
    public void setValue(String string) {
        this.value = string;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Triggers triggers) {
        this.triggers = triggers;
    }

    @Override
    public void addNotifiedUsers(QualifiedUsers notifyUsers) {
        this.notifiedUsersList.add(notifyUsers);
    }
}

