/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.event;

import java.util.Date;
import org.silverpeas.core.contribution.content.form.DataRecord;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.api.task.Task;
import org.silverpeas.core.workflow.api.user.User;

public class AbstractTaskEvent
implements GenericEvent {
    private User user;
    private ProcessInstance processInstance;
    private ProcessModel processModel;
    private Date actionDate;
    private String actionName;
    private String userRoleName;
    private State resolvedState;
    private DataRecord data;
    private User substitute;

    public AbstractTaskEvent(Task resolvedTask, String actionName, DataRecord data) {
        this.user = resolvedTask.getUser();
        this.processModel = resolvedTask.getProcessModel();
        this.processInstance = resolvedTask.getProcessInstance();
        this.resolvedState = resolvedTask.getState();
        this.actionName = actionName;
        this.actionDate = new Date();
        this.userRoleName = resolvedTask.getUserRoleName();
        this.data = data;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    @Override
    public State getResolvedState() {
        return this.resolvedState;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public Date getActionDate() {
        return this.actionDate;
    }

    @Override
    public DataRecord getDataRecord() {
        return this.data;
    }

    @Override
    public String getUserRoleName() {
        return this.userRoleName;
    }

    @Override
    public User getSubstitute() {
        return this.substitute;
    }

    @Override
    public void setSubstitute(User substitute) {
        this.substitute = substitute;
    }

    @Override
    public User getUserOrSubstitute() {
        return this.getSubstitute() == null ? this.getUser() : this.getSubstitute();
    }
}

