/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.error;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.workflow.api.ErrorManager;
import org.silverpeas.core.workflow.api.error.WorkflowError;
import org.silverpeas.core.workflow.api.event.GenericEvent;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.engine.error.ErrorRepository;
import org.silverpeas.core.workflow.engine.error.WorkflowErrorImpl;

@Service
@Singleton
public class ErrorManagerImpl
implements ErrorManager {
    @Inject
    ErrorRepository repository;

    @Override
    @Transactional
    public WorkflowError saveError(ProcessInstance instance, GenericEvent event, Exception exception) {
        WorkflowErrorImpl error = new WorkflowErrorImpl(instance, event, exception);
        this.repository.save((IdentifiableEntity)error);
        return error;
    }

    @Override
    public WorkflowError[] getErrorsOfInstance(String instanceId) {
        List<WorkflowErrorImpl> errors = this.repository.getByProcessInstanceId(instanceId);
        return errors.toArray(new WorkflowError[errors.size()]);
    }

    @Override
    @Transactional
    public void removeErrorsOfInstance(String instanceId) {
        this.repository.deleteByProcessInstanceId(instanceId);
    }
}

