/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.util.StringTokenizer;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.silverpeas.core.silverstatistics.volume.model.StatType;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatistics;
import org.silverpeas.core.silverstatistics.volume.service.SilverStatisticsProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="acknowledgeMode", propertyValue="Auto-acknowledge"), @ActivationConfigProperty(propertyName="destinationLookup", propertyValue="jms/queue/statisticsQueue")}, description="Message driven bean for statistics insertion")
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class SilverStatisticsMessageDriven
implements MessageListener {
    public void onMessage(Message message) {
        TextMessage textMessage = (TextMessage)message;
        try {
            String msg = textMessage.getText();
            StringTokenizer stData = new StringTokenizer(msg, "&&&");
            if (stData.hasMoreTokens()) {
                String typeOfStats = stData.nextToken();
                if (typeOfStats.length() + "&&&".length() < msg.length()) {
                    String stat = msg.substring(typeOfStats.length() + "&&&".length(), msg.length());
                    this.getSilverStatistics().putStats(StatType.valueOf(typeOfStats), stat);
                } else {
                    SilverLogger.getLogger((Object)this).error("Wrong message: {0}", new Object[]{msg});
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
        }
    }

    private SilverStatistics getSilverStatistics() {
        return SilverStatisticsProvider.getSilverStatistics();
    }
}

