/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.silverstatistics.volume.service;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.silverpeas.core.silverstatistics.volume.model.DirectoryStats;
import org.silverpeas.core.silverstatistics.volume.service.AbstractComputer;
import org.silverpeas.core.silverstatistics.volume.service.ComponentStatisticsProvider;

public class DirectorySizeComputer
extends AbstractComputer {
    private long size = 0L;

    DirectorySizeComputer(File directory, boolean onlyComponentData) {
        super(directory, onlyComponentData);
    }

    @Override
    protected void handleTransverseFile(Path file, BasicFileAttributes attrs) {
        this.size += attrs.size();
    }

    @Override
    protected void setTransverseResult(DirectoryStats result) {
        result.addDirectorySize(this.size);
    }

    @Override
    protected void setSpecificResult(DirectoryStats result, ComponentStatisticsProvider componentStatistics) {
        result.addDirectorySize(componentStatistics.memorySizeOfSpecificFiles(result.getDirectoryName()));
    }
}

