/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.wbe;

import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.wbe.WbeFile;
import org.silverpeas.core.wbe.WbeHostManager;
import org.silverpeas.core.wbe.WbeLogger;
import org.silverpeas.core.webapi.wbe.WbeFileEditionContext;
import org.silverpeas.core.webapi.wbe.WbeFileWrapper;
import org.silverpeas.core.webapi.wbe.WbeProtectedWebResource;
import org.silverpeas.core.webapi.wbe.WbeRequestContext;
import org.silverpeas.core.webapi.wbe.WbeResponseError;

public abstract class AbstractWbeFileResource
implements WbeProtectedWebResource {
    @PathParam(value="fileId")
    private String fileId;
    private WbeFileEditionContext editionContext;
    @Inject
    private WbeRequestContext requestContext;
    @Inject
    private WbeHostManager editionManager;
    @Context
    private HttpServletRequest httpRequest;
    @Context
    private HttpServletResponse httpResponse;

    @PostConstruct
    protected void initContext() {
        this.requestContext.init(this.httpRequest, this.httpResponse);
    }

    @Override
    public WbeRequestContext getSilverpeasContext() {
        return this.requestContext;
    }

    protected Response process(Supplier<Response> supplier) {
        try {
            String accessToken = this.requestContext.getAccessToken();
            this.editionContext = (WbeFileEditionContext)this.getHostManager().getEditionContextFrom(this.fileId, accessToken, (u, f) -> new WbeFileEditionContext(u.orElse(null), f.map(this::wrapWbeFile).orElse(null)));
            Optional<Response> errorResponse = this.checkEditionContext();
            return errorResponse.orElseGet(supplier);
        }
        catch (WbeResponseError e) {
            return e.getResponse();
        }
        catch (Exception e) {
            WbeLogger.logger().error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    protected abstract WbeFileWrapper wrapWbeFile(WbeFile var1);

    private Optional<Response> checkEditionContext() {
        if (this.editionContext.getUser() == null) {
            return Optional.of(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        User user = this.editionContext.getUser().asSilverpeas();
        WbeFile wbeFile = this.editionContext.getFile();
        if (wbeFile == null) {
            return Optional.of(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        if ("GET".equals(this.httpRequest.getMethod()) && !wbeFile.canBeAccessedBy(user)) {
            String error = MessageFormat.format("User {0} can not access the file {1}", user.getId(), wbeFile);
            WbeLogger.logger().error(error, new Object[0]);
            return Optional.of(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        if (!"GET".equals(this.httpRequest.getMethod()) && !wbeFile.canBeModifiedBy(user)) {
            String error = MessageFormat.format("User {0} can not modify the file {1}", user.getId(), wbeFile);
            WbeLogger.logger().error(error, new Object[0]);
            return Optional.of(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        return Optional.empty();
    }

    protected WbeFileEditionContext getEditionContext() {
        return this.editionContext;
    }

    protected WbeHostManager getHostManager() {
        return this.editionManager;
    }
}

