/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.viewer;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.webapi.viewer.ResourceViewProvider;

@Singleton
public class ResourceViewProviderRegistry {
    private final Map<String, List<ResourceViewProvider>> newRegistry = new HashMap<String, List<ResourceViewProvider>>();

    protected ResourceViewProviderRegistry() {
    }

    public static ResourceViewProviderRegistry get() {
        return (ResourceViewProviderRegistry)ServiceProvider.getService(ResourceViewProviderRegistry.class, (Annotation[])new Annotation[0]);
    }

    public void addNewEmbedMediaProvider(ResourceViewProvider provider) {
        this.newRegistry.compute(provider.relatedToService().toLowerCase(), (k, l) -> {
            if (l == null) {
                l = new ArrayList<ResourceViewProvider>();
            }
            l.add(provider);
            return l;
        });
    }

    protected List<ResourceViewProvider> getByResourceType(String resourceType) {
        return Optional.ofNullable(resourceType).map(String::toLowerCase).map(this.newRegistry::get).orElse(Collections.emptyList());
    }
}

