/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.viewer;

import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.viewer.model.DocumentView;
import org.silverpeas.core.viewer.model.Preview;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.core.webapi.viewer.AbstractPreviewEntity;
import org.silverpeas.kernel.util.StringUtil;

public class DocumentViewEntity
extends AbstractPreviewEntity<DocumentViewEntity> {
    private static final long serialVersionUID = 4270519541076741138L;
    private String viewerUri;
    private String viewMode = "Default";

    public static DocumentViewEntity createFrom(DocumentView documentView) {
        return new DocumentViewEntity(documentView);
    }

    private DocumentViewEntity(DocumentView documentView) {
        super((Preview)documentView);
        this.viewerUri = URLUtil.getApplicationURL() + "/services/media/viewer/embed/";
        if (documentView.getServerFilePath().endsWith("file.pdf")) {
            this.viewerUri = this.viewerUri + "pdf";
        } else {
            if (StringUtil.isDefined((String)ViewerSettings.getLicenceKey())) {
                this.viewMode = "Zine";
            }
            this.viewerUri = this.viewerUri + "fp";
        }
        this.viewerUri = this.viewerUri + "?documentId=" + this.getDocumentId() + "&documentType=" + this.getDocumentType() + "&language=" + this.getLanguage();
    }

    protected DocumentViewEntity() {
    }

    public String getViewerUri() {
        return this.viewerUri;
    }

    public String getViewMode() {
        return this.viewMode;
    }
}

