/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.variables;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.net.URI;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.date.TemporalFormatter;
import org.silverpeas.core.variables.VariableScheduledValue;
import org.silverpeas.core.web.rs.WebEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VariableScheduledValueEntity
implements WebEntity {
    private URI uri;
    private String id;
    private String value;
    private String beginDate;
    private String endDate;

    public static VariableScheduledValueEntity fromVariableScheduledValue(VariableScheduledValue value) {
        return new VariableScheduledValueEntity().decorate(value);
    }

    public VariableScheduledValue toVariableScheduledValue() {
        return new VariableScheduledValue(this.value, this.getPeriod());
    }

    protected VariableScheduledValueEntity decorate(VariableScheduledValue vPeriod) {
        this.id = vPeriod.getId();
        this.value = vPeriod.getValue();
        Period period = vPeriod.getPeriod();
        if (!period.startsAtMinDate()) {
            this.beginDate = TemporalConverter.asLocalDate((Temporal)period.getStartDate()).toString();
        }
        if (!period.endsAtMaxDate()) {
            this.endDate = TemporalConverter.asLocalDate((Temporal)period.getEndDate()).toString();
        }
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private Period getPeriod() {
        LocalDate start = this.getDate(this.beginDate);
        LocalDate end = this.getDate(this.endDate);
        return Period.betweenNullable((LocalDate)start, (LocalDate)end);
    }

    private LocalDate getDate(String iso8601Date) {
        Temporal date = TemporalFormatter.toTemporal((String)iso8601Date, (boolean)false);
        return date == null ? null : TemporalConverter.asLocalDate((Temporal)date);
    }
}

