/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.util.logging;

import java.net.URI;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlElement;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.logging.Level;
import org.silverpeas.kernel.logging.LoggerConfigurationManager;
import org.silverpeas.kernel.logging.SilverLoggerProvider;

public class LoggerConfigurationEntity
implements WebEntity {
    public static final String PARENT_LEVEL = "PARENT";
    @XmlElement(defaultValue="")
    private URI uri;
    private String logger;
    private String level;

    protected LoggerConfigurationEntity() {
    }

    private LoggerConfigurationEntity(String logger, String level) {
        this.logger = logger;
        this.level = level == null || level.trim().isEmpty() ? PARENT_LEVEL : level;
    }

    public static LoggerConfigurationEntity toWebEntity(LoggerConfigurationManager.LoggerConfiguration configuration) {
        String level = configuration.getLevel() == null ? PARENT_LEVEL : configuration.getLevel().name();
        return new LoggerConfigurationEntity(configuration.getNamespace(), level);
    }

    public LoggerConfigurationEntity withAsURi(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLogger() {
        return this.logger;
    }

    public String getLevel() {
        return this.level;
    }

    public LoggerConfigurationManager.LoggerConfiguration toLoggerConfiguration() {
        Level loggingLevel = this.isLevelDefined(this.getLevel()) ? Level.valueOf((String)this.getLevel()) : null;
        return SilverLoggerProvider.getInstance().getConfigurationManager().getLoggerConfiguration(this.getLogger()).withLevel(loggingLevel);
    }

    private boolean isLevelDefined(String level) {
        return Arrays.stream(Level.values()).anyMatch(l -> l.name().equals(level));
    }
}

