/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.pdc.pdc.model.Axis;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.pdc.PdcEntity;
import org.silverpeas.core.webapi.pdc.PdcServiceProvider;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="pdc")
@Authenticated
public class PdcResource
extends RESTWebService {
    static final String PATH = "pdc";
    @Inject
    private PdcServiceProvider pdcServiceProvider;
    private String componentId;

    @GET
    @Path(value="{componentId:[a-zA-Z]+[0-9]+}")
    @Produces(value={"application/json"})
    public PdcEntity getPdcForClassification(@PathParam(value="componentId") String component, @QueryParam(value="contentId") String content) {
        this.setComponentId(component);
        try {
            List<UsedAxis> axis = StringUtil.isDefined((String)content) ? this.pdcServiceProvider().getAxisUsedInPdcToClassify(content, PdcServiceProvider.inComponentOfId(this.getComponentId())) : this.pdcServiceProvider().getAxisUsedInPdcFor(this.getComponentId());
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithUsedAxis(axis, PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUri().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (ContentManagerException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public PdcEntity getPdc() {
        try {
            List<Axis> axis = this.pdcServiceProvider().getAllAxis();
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithAxis(axis, PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUri().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    protected String getResourceBasePath() {
        return PATH;
    }

    public String getComponentId() {
        return this.componentId;
    }

    private void setComponentId(String componentId) {
        int index = componentId.indexOf("?contentId");
        this.componentId = index > 0 ? componentId.substring(0, index) : componentId;
        UserPrivilegeValidation validation = UserPrivilegeValidation.get();
        this.validateUserAuthorization(validation);
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private UserThesaurusHolder withThesaurusAccordingTo(UserPreferences userPreferences) {
        UserThesaurusHolder thesaurus = PdcEntity.NoThesaurus;
        if (userPreferences.isThesaurusEnabled()) {
            thesaurus = this.pdcServiceProvider().getThesaurusOfUser(UserDetail.from((User)this.getUser()));
        }
        return thesaurus;
    }
}

