/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.pdc.pdc.model.AxisValueCriterion;
import org.silverpeas.core.pdc.pdc.model.UsedAxis;
import org.silverpeas.core.personalization.UserPreferences;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.annotation.Authenticated;
import org.silverpeas.core.webapi.pdc.PdcEntity;
import org.silverpeas.core.webapi.pdc.PdcFilterCriteria;
import org.silverpeas.core.webapi.pdc.PdcServiceProvider;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.logging.SilverLogger;

@WebService
@Path(value="pdc/filter")
@Authenticated
public class FilteredPdcResource
extends RESTWebService {
    static final String PATH = "pdc/filter";
    @Inject
    private PdcServiceProvider pdcServiceProvider;

    protected String getResourceBasePath() {
        return PATH;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="used")
    public PdcEntity getPdcFilteredByClassifiedContents(@QueryParam(value="workspaceId") String workspaceId, @QueryParam(value="componentId") List<String> componentIds, @QueryParam(value="withSecondaryAxis") boolean withSecondaryAxis, @QueryParam(value="values") String axisValues) {
        PdcFilterCriteria criteria = new PdcFilterCriteria().onWorkspace(workspaceId).onComponentInstances(componentIds).onSecondaryAxisInclusion(withSecondaryAxis).onUser(UserDetail.from((User)this.getUser()));
        this.setAxisValues(criteria, axisValues);
        try {
            List<UsedAxis> axis = this.pdcServiceProvider().getAxisUsedInClassificationsByCriteria(criteria);
            UserPreferences userPreferences = this.getUserPreferences();
            return PdcEntity.aPdcEntityWithUsedAxis(PdcEntity.withAxis(axis), PdcEntity.inLanguage(userPreferences.getLanguage()), PdcEntity.atURI(this.getUri().getRequestUri()), this.withThesaurusAccordingTo(userPreferences));
        }
        catch (Exception ex) {
            SilverLogger.getLogger((Object)((Object)this)).error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public String getComponentId() {
        return null;
    }

    private PdcServiceProvider pdcServiceProvider() {
        return this.pdcServiceProvider;
    }

    private void setAxisValues(PdcFilterCriteria criteria, String axisValues) {
        List axisValuesCriteria = AxisValueCriterion.fromFlattenedAxisValues((String)axisValues);
        criteria.onAxisValues(axisValuesCriteria);
    }

    private UserThesaurusHolder withThesaurusAccordingTo(UserPreferences userPreferences) {
        UserThesaurusHolder thesaurus = PdcEntity.NoThesaurus;
        if (userPreferences.isThesaurusEnabled()) {
            thesaurus = this.pdcServiceProvider().getThesaurusOfUser(UserDetail.from((User)this.getUser()));
        }
        return thesaurus;
    }
}

