/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.password;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.security.authentication.password.rule.PasswordRule;
import org.silverpeas.core.security.authentication.password.service.PasswordCheck;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PasswordCheckEntity
implements Serializable {
    @XmlElement
    private boolean isCorrect;
    @XmlElement
    private boolean isRuleCombinationRespected;
    @XmlElement
    private String checkId;
    @XmlElement
    private final Collection<String> requiredRuleIdsInError = new ArrayList<String>();
    @XmlElement
    private final Collection<String> combinedRuleIdsInError = new ArrayList<String>();

    public static PasswordCheckEntity createFrom(PasswordCheck passwordCheck) {
        return new PasswordCheckEntity(passwordCheck);
    }

    private PasswordCheckEntity(PasswordCheck passwordCheck) {
        this.isCorrect = passwordCheck.isCorrect();
        this.isRuleCombinationRespected = passwordCheck.isRuleCombinationRespected();
        this.checkId = passwordCheck.getId();
        for (PasswordRule rule : passwordCheck.getRequiredRulesInError()) {
            this.requiredRuleIdsInError.add(rule.getType().name());
        }
        for (PasswordRule rule : passwordCheck.getCombinedRulesInError()) {
            this.combinedRuleIdsInError.add(rule.getType().name());
        }
    }

    protected PasswordCheckEntity() {
    }

    public String getCheckId() {
        return this.checkId;
    }

    public boolean isCorrect() {
        return this.isCorrect;
    }

    public boolean isRuleCombinationRespected() {
        return this.isRuleCombinationRespected;
    }

    public Collection<String> getRequiredRuleIdsInError() {
        return this.requiredRuleIdsInError;
    }

    public Collection<String> getCombinedRuleIdsInError() {
        return this.combinedRuleIdsInError;
    }
}

