/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.node;

import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.sharing.model.Ticket;
import org.silverpeas.core.sharing.security.AccessControlContext;
import org.silverpeas.core.sharing.services.SharingServiceProvider;
import org.silverpeas.core.webapi.node.AbstractNodeResource;

@WebService
@Path(value="sharing/nodes/{componentId}/{token}")
public class SharedNodeResource
extends AbstractNodeResource {
    static final String PATH = "sharing/nodes";
    @PathParam(value="token")
    private String token;

    protected String getResourceBasePath() {
        return PATH;
    }

    @Override
    protected boolean isNodeReadable(NodeDetail node) {
        Ticket ticket = SharingServiceProvider.getSharingTicketService().getTicket(this.token);
        AccessControlContext ctx = AccessControlContext.about((NodeDetail)node);
        return ticket != null && ticket.getAccessControl().isReadable(ctx);
    }
}

