/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.admin.scim;

import edu.psu.swe.scim.server.exception.UnableToRetrieveResourceException;
import edu.psu.swe.scim.spec.protocol.filter.AttributeComparisonExpression;
import edu.psu.swe.scim.spec.protocol.filter.CompareOperator;
import edu.psu.swe.scim.spec.protocol.filter.FilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalExpression;
import edu.psu.swe.scim.spec.protocol.filter.LogicalOperator;
import java.text.MessageFormat;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.service.Administration;
import org.silverpeas.core.admin.user.model.SearchCriteria;
import org.silverpeas.core.webapi.admin.scim.ScimRequestContext;
import org.silverpeas.kernel.util.StringUtil;

abstract class AbstractScimAdminService {
    @Inject
    protected ScimRequestContext scimRequestContext;
    @Inject
    protected Administration admin;

    AbstractScimAdminService() {
    }

    protected void validateDomainExists() {
        if (StringUtil.isNotDefined((String)this.scimRequestContext.getDomainId())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    protected <T extends SearchCriteria> T processExpression(FilterExpression expression, T searchCriteria) throws UnableToRetrieveResourceException {
        if (expression instanceof LogicalExpression) {
            LogicalExpression le = (LogicalExpression)expression;
            this.processExpression(le.getLeft(), searchCriteria);
            this.processExpression(le.getRight(), searchCriteria);
            if (le.getOperator().equals((Object)LogicalOperator.OR)) {
                throw new UnableToRetrieveResourceException(Response.Status.NOT_IMPLEMENTED, "impossible to perform OR logical operation");
            }
        } else if (expression instanceof AttributeComparisonExpression) {
            AttributeComparisonExpression ace = (AttributeComparisonExpression)expression;
            String attributeBase = ace.getAttributePath().getFullAttributeName();
            if (ace.getOperation() == CompareOperator.EQ) {
                if ("id".equals(attributeBase)) {
                    searchCriteria.onUserIds(new String[]{(String)ace.getCompareValue()});
                    return searchCriteria;
                }
                if ("externalId".equals(attributeBase)) {
                    searchCriteria.onUserSpecificIds(new String[]{(String)ace.getCompareValue()});
                    return searchCriteria;
                }
            }
            throw new UnableToRetrieveResourceException(Response.Status.BAD_REQUEST, MessageFormat.format("Unable to apply operator {0} on attribute {1}", ace.getOperation(), ace.getAttributePath().getFullAttributeName()));
        }
        return searchCriteria;
    }
}

