/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.wysiwyg;

import java.text.MessageFormat;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.cache.service.VolatileCacheServiceProvider;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.util.WysiwygEditorConfig;
import org.silverpeas.kernel.util.StringUtil;

public class WysiwygEditor {
    private String replace;
    private WysiwygEditorConfig config;
    private boolean activateWysiwygBackupManager;
    private String componentInstanceId;
    private String resourceType;
    private String resourceId;
    private static final String DD_UPLOAD_TEMPLATE_SCRIPT = "whenSilverpeasReady(function() '{'configureCkEditorDdUpload('{'componentInstanceId : ''{0}'',resourceId : ''{1}'', indexIt : {2}'}');'}');\n";

    public WysiwygEditor(String componentInstanceId, String resourceType, String resourceId, boolean activateWysiwygBackupManager) {
        ComponentInstLight componentInst;
        this.componentInstanceId = componentInstanceId;
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.activateWysiwygBackupManager = activateWysiwygBackupManager;
        String componentName = "";
        if (StringUtil.isDefined((String)componentInstanceId) && (componentInst = OrganizationController.get().getComponentInstLight(componentInstanceId)) != null) {
            componentName = componentInst.getName();
        }
        this.config = new WysiwygEditorConfig(componentName);
        this.config.setComponentId(componentInstanceId);
        this.config.setObjectId(resourceId);
    }

    public String print() {
        String js = "CKEDITOR.replace('" + this.getReplace() + "', " + this.config.toJSON() + ");\n";
        js = js + "sp.editor.wysiwyg.fullScreenOnMaximize('" + this.getReplace() + "');\n";
        if (this.activateWysiwygBackupManager) {
            boolean notVolatileId = !VolatileCacheServiceProvider.getSessionVolatileResourceCacheService().contains(this.resourceId, this.componentInstanceId);
            js = js + "sp.editor.wysiwyg.backupManager(" + JSONCodec.encodeObject(o -> {
                o.put("componentInstanceId", StringUtil.defaultStringIfNotDefined((String)this.componentInstanceId));
                o.put("resourceType", StringUtil.defaultStringIfNotDefined((String)this.resourceType));
                o.put("resourceId", StringUtil.defaultStringIfNotDefined((String)(notVolatileId ? this.resourceId : "")));
                return o;
            }) + ");\n";
        }
        if (!(this.componentInstanceId == null || this.componentInstanceId.startsWith("webSites") && StringUtil.isLong((String)this.resourceId))) {
            js = js + MessageFormat.format(DD_UPLOAD_TEMPLATE_SCRIPT, this.componentInstanceId, this.resourceId, false);
        }
        return js;
    }

    public String getLanguage() {
        return this.config.getLanguage();
    }

    public String getReplace() {
        return this.replace;
    }

    public void setReplace(String replace) {
        this.replace = replace;
    }

    public void setHeight(String height) {
        this.config.setHeight(height);
    }

    public void setWidth(String width) {
        this.config.setWidth(width);
    }

    public void setLanguage(String language) {
        this.config.setLanguage(language);
    }

    public void setToolbar(String toolbar) {
        this.config.setToolbar(toolbar);
    }

    public void setToolbarStartExpanded(boolean toolbarStartExpanded) {
        this.config.setToolbarStartExpanded(toolbarStartExpanded);
    }

    public void setCustomCSS(String css) {
        this.config.setStylesheet(css);
    }

    public void setDisplayFileBrowser(boolean displayFileBrowser) {
        this.config.setFileBrowserDisplayed(displayFileBrowser);
    }
}

