/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.list;

import java.util.List;
import javax.servlet.jsp.tagext.Tag;
import org.silverpeas.core.util.PaginationList;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.util.viewgenerator.html.list.AbstractListItemsTag;
import org.silverpeas.core.web.util.viewgenerator.html.list.AccumulativeListPaneTag;

public class AccumulativeListItemsTag
extends AbstractListItemsTag {
    private static final long serialVersionUID = 8537592673853508370L;

    @Override
    protected <T> SilverpeasList<T> optimize(List<T> list) {
        int currentIndex;
        AccumulativeListPaneTag pane = this.getListPane();
        SilverpeasList silverpeasList = SilverpeasList.wrap(list);
        int originalListSize = (int)silverpeasList.originalListSize();
        AccumulativeListPaneTag.State state = pane.getState();
        int batchSize = state.getBatchSize();
        if (state.isFirstDisplay()) {
            currentIndex = 0;
        } else if (silverpeasList.isSlice()) {
            currentIndex = state.getCurrentStartIndex() + batchSize;
        } else {
            int offset = Math.max(originalListSize - state.getCurrentListSize(), 0);
            currentIndex = state.getCurrentStartIndex() + offset + batchSize;
        }
        state.setCurrentListSize(originalListSize);
        state.setCurrentStartIndex(currentIndex);
        int nextIndex = Math.min(currentIndex + batchSize, originalListSize);
        state.setNextStartIndex(nextIndex);
        pane.setMoreItems(nextIndex < originalListSize);
        if (silverpeasList.isSlice()) {
            return silverpeasList;
        }
        int lastIndex = Math.min(currentIndex + batchSize, originalListSize);
        return PaginationList.from(list.subList(currentIndex, lastIndex), (long)list.size());
    }

    protected AccumulativeListPaneTag getListPane() {
        return (AccumulativeListPaneTag)AccumulativeListItemsTag.findAncestorWithClass((Tag)this, AccumulativeListPaneTag.class);
    }
}

