/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.formpanes;

import java.util.Vector;
import javax.servlet.jsp.PageContext;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.formpanes.FormLine;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

public abstract class FormPane
implements SimpleGraphicElement {
    public static final String PUBLIEUR_CODE = "publieur";
    public static final String UTILISATEUR_CODE = "utilisateur";
    public static final String DEFAULT_LANGUAGE = "fr";
    protected Vector formLines = new Vector();
    protected Vector formHiddenFields = new Vector();
    protected Vector formActionButtons = new Vector();
    protected String actionURL;
    protected String formMethod;
    protected String title = null;
    protected String name;
    protected String displayName;
    protected String description;
    protected PageContext pageContext = null;
    protected boolean reply;
    protected LocalizationBundle message;
    protected boolean utilisateurArchivageDemandes;
    protected boolean publieurArchivageDemandes;
    protected boolean utilisateurArchivageReponses;
    protected boolean publieurArchivageReponses;
    protected boolean utilisateurEnvoiDemandes;

    public FormPane(String nam, String url, PageContext pc) {
        this.name = nam;
        this.description = "";
        this.displayName = nam;
        this.pageContext = pc;
        this.actionURL = url;
        this.formMethod = "post";
        this.reply = false;
        this.utilisateurArchivageDemandes = false;
        this.publieurArchivageDemandes = false;
        this.utilisateurArchivageReponses = false;
        this.publieurArchivageReponses = false;
        this.utilisateurEnvoiDemandes = false;
        this.message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.viewGenerator.formPane.formPaneBundle", (String)DEFAULT_LANGUAGE);
    }

    public void setTitle(String title2) {
        this.title = title2;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nam) {
        this.name = nam;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String nam) {
        this.displayName = nam;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public Vector getFormLines() {
        return this.formLines;
    }

    public int getNbLines() {
        return this.formLines.size() + this.formHiddenFields.size() + this.formActionButtons.size();
    }

    public boolean hasReply() {
        return this.reply;
    }

    public void setReply(boolean rep) {
        this.reply = rep;
        if (rep) {
            this.utilisateurEnvoiDemandes = true;
            this.publieurArchivageDemandes = true;
        }
    }

    public boolean getUtilisateurArchivageDemandes() {
        return this.utilisateurArchivageDemandes;
    }

    public void setUtilisateurArchivageDemandes(boolean uad) {
        this.utilisateurArchivageDemandes = uad;
    }

    public boolean getPublieurArchivageDemandes() {
        return this.publieurArchivageDemandes;
    }

    public void setPublieurArchivageDemandes(boolean uad) {
        this.publieurArchivageDemandes = uad;
    }

    public boolean getUtilisateurArchivageReponses() {
        return this.utilisateurArchivageReponses;
    }

    public void setUtilisateurArchivageReponses(boolean uad) {
        this.utilisateurArchivageReponses = uad;
    }

    public boolean getPublieurArchivageReponses() {
        return this.publieurArchivageReponses;
    }

    public void setPublieurArchivageReponses(boolean uad) {
        this.publieurArchivageReponses = uad;
    }

    public boolean getUtilisateurEnvoiDemandes() {
        return this.utilisateurEnvoiDemandes;
    }

    public void setUtilisateurEnvoiDemandes(boolean uad) {
        this.utilisateurEnvoiDemandes = uad;
    }

    public void setLanguage(String language) {
        if (language != null) {
            this.message = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.viewGenerator.formPane.formPaneBundle", (String)language);
        }
    }

    public void add(FormLine line) {
        line.setPane(this);
        line.setLanguage(this.message.getLocale().getLanguage());
        if (line.getType().equals("hidden")) {
            this.formHiddenFields.add(line);
        } else if (line.getType().equals("button")) {
            this.formActionButtons.add(line);
        } else if (line.getType().equals("buttonLine")) {
            this.formActionButtons.add(line);
        } else {
            this.formLines.add(line);
        }
    }

    public void remove(String lineName) {
        FormLine fl;
        int i;
        boolean search = true;
        if (search && this.formLines.size() > 0) {
            for (i = 0; search && i < this.formLines.size(); ++i) {
                fl = (FormLine)this.formLines.elementAt(i);
                if (!fl.getName().equals(lineName)) continue;
                this.formLines.removeElementAt(i);
                search = false;
            }
        }
        if (search && this.formHiddenFields.size() > 0) {
            for (i = 0; search && i < this.formHiddenFields.size(); ++i) {
                fl = (FormLine)this.formHiddenFields.elementAt(i);
                if (!fl.getName().equals(lineName)) continue;
                this.formHiddenFields.removeElementAt(i);
                search = false;
            }
        }
        if (search && this.formActionButtons.size() > 0) {
            for (i = 0; search && i < this.formActionButtons.size(); ++i) {
                fl = (FormLine)this.formActionButtons.elementAt(i);
                if (!fl.getName().equals(lineName)) continue;
                this.formActionButtons.removeElementAt(i);
                search = false;
            }
        }
    }

    public String toXML() {
        int i;
        StringBuilder result = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        result.append("\n\n").append(this.getDTD());
        result.append("\n\n<formulaire>");
        result.append("\n<name>" + this.name + "</name>");
        result.append("\n<displayName>" + this.displayName + "</displayName>");
        result.append("\n<description>" + this.description + "</description>");
        result.append("\n<reply>" + String.valueOf(this.reply) + "</reply>");
        result.append("\n<utilisateurArchivageDemandes>").append(String.valueOf(this.utilisateurArchivageDemandes)).append("</utilisateurArchivageDemandes>");
        result.append("\n<publieurArchivageDemandes>").append(String.valueOf(this.publieurArchivageDemandes)).append("</publieurArchivageDemandes>");
        result.append("\n<utilisateurArchivageReponses>").append(String.valueOf(this.utilisateurArchivageReponses)).append("</utilisateurArchivageReponses>");
        result.append("\n<publieurArchivageReponses>").append(String.valueOf(this.publieurArchivageReponses)).append("</publieurArchivageReponses>");
        result.append("\n<utilisateurEnvoiDemandes>").append(String.valueOf(this.utilisateurEnvoiDemandes)).append("</utilisateurEnvoiDemandes>");
        if (this.formHiddenFields.size() > 0) {
            for (i = 0; i < this.formHiddenFields.size(); ++i) {
                result.append(((FormLine)this.formHiddenFields.elementAt(i)).toXML());
            }
        }
        if (this.formLines.size() > 0) {
            for (i = 0; i < this.formLines.size(); ++i) {
                result.append("\n" + ((FormLine)this.formLines.elementAt(i)).toXML());
            }
        }
        if (this.formActionButtons.size() > 0) {
            for (i = 0; i < this.formActionButtons.size(); ++i) {
                result.append("\n").append(((FormLine)this.formActionButtons.elementAt(i)).toXML());
            }
        }
        result.append("\n</formulaire>");
        return this.toXMLString(result.toString());
    }

    private String toXMLString(String s) {
        byte[] readbytes = s.getBytes(Charsets.UTF_8);
        return new String(readbytes);
    }

    public String getBuildRequest() {
        StringBuilder result = new StringBuilder();
        if (this.formLines.size() > 0) {
            for (int i = 0; i < this.formLines.size(); ++i) {
                result.append(((FormLine)this.formLines.elementAt(i)).getDBColumnCreationRequest());
            }
        }
        return result.toString();
    }

    public void initFromVector(Vector resultVector) {
        int j = 0;
        for (int i = 0; i < this.formLines.size(); ++i) {
            FormLine fl = (FormLine)this.formLines.elementAt(i);
            if (!fl.isDBEntry()) continue;
            fl.setValue((String)resultVector.elementAt(j));
            ++j;
        }
    }

    public String getDTD() {
        Object retour = "<!DOCTYPE formulaire [";
        retour = (String)retour + "\n<!ELEMENT formulaire (name, displayName, description, reply, utilisateurArchivageDemandes, publieurArchivageDemandes,";
        retour = (String)retour + "\n       utilisateurArchivageReponses, publieurArchivageReponses, utilisateurEnvoiDemandes, field*)>";
        retour = (String)retour + "\n<!ELEMENT field (name, label, value, rows?, cols?, size?, dbtype?, actions?)>";
        retour = (String)retour + "\n<!ATTLIST field ";
        retour = (String)retour + "\nid CDATA\t#REQUIRED";
        retour = (String)retour + "\ntype CDATA\t#REQUIRED>";
        retour = (String)retour + "\n<!ELEMENT name (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT displayName (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT description (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT reply (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT utilisateurArchivageDemandes (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT publieurArchivageDemandes \t(#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT utilisateurArchivageReponses (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT publieurArchivageReponses \t(#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT utilisateurEnvoiDemandes \t(#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT label (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT value (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT size (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT rows (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT cols (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT dbtype (#PCDATA)>";
        retour = (String)retour + "\n<!ELEMENT actions (action*)>";
        retour = (String)retour + "\n<!ELEMENT action EMPTY>";
        retour = (String)retour + "\n<!ATTLIST action ";
        retour = (String)retour + "\nid CDATA #REQUIRED";
        retour = (String)retour + "\nvalue CDATA #REQUIRED>";
        retour = (String)retour + "\n]>";
        return retour;
    }

    @Override
    public abstract String print();

    public abstract String printDemo(String var1, String var2, String var3);

    public abstract String printHeader(String var1, String var2, String var3);
}

