/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html.arraypanes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.silverpeas.core.web.util.viewgenerator.html.SimpleGraphicElement;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ActionableArrayCell;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayLine;

public class ArrayCellSelect
extends ActionableArrayCell
implements SimpleGraphicElement {
    private final ArrayList<String> values = new ArrayList();
    private String size = null;
    private final ArrayList<String> labels = new ArrayList();
    private final ArrayList<Integer> selected = new ArrayList();
    private String color = null;
    private String bgcolor = null;
    private String textAlign = null;
    private boolean readOnly = false;
    private boolean multiselect = false;
    private final StringBuilder syntax = new StringBuilder();

    public ArrayCellSelect(String name, String[] labels, String[] values, ArrayLine line) {
        super(name, line);
        this.values.addAll(Arrays.asList(values));
        this.labels.addAll(Arrays.asList(labels));
    }

    public ArrayCellSelect(String name, List<String> values, ArrayLine line) {
        super(name, line);
        this.values.addAll(values);
        this.labels.addAll(values);
    }

    public String[] getSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (Integer aSelected : this.selected) {
            selectedValues.add(this.values.get(aSelected));
        }
        return selectedValues.toArray(new String[0]);
    }

    public void setSelectedValues(String[] selectedValues) {
        this.selected.clear();
        for (String selectedValue : selectedValues) {
            int index = this.values.indexOf(selectedValue);
            if (index == -1) continue;
            this.selected.add(index);
        }
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String strSize) {
        this.size = strSize;
    }

    public boolean isMultiselect() {
        return this.multiselect;
    }

    public void setMultiselect(boolean fMultiselect) {
        this.multiselect = fMultiselect;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String strColor) {
        this.color = strColor;
    }

    public String getBgcolor() {
        return this.bgcolor;
    }

    public void setBgcolor(String strBgcolor) {
        this.bgcolor = strBgcolor;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String strTextAlign) {
        this.textAlign = strTextAlign;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean fReadOnly) {
        this.readOnly = fReadOnly;
    }

    @Override
    public String getSyntax() {
        this.syntax.append(" <select name=\"");
        if (this.getName() == null) {
            this.syntax.append("selectfield\"");
        } else {
            this.syntax.append(this.getName()).append("\"");
        }
        if (this.getSize() != null) {
            this.syntax.append(" size=\"").append(this.getSize()).append("\"");
        }
        this.syntax.append(" style=\"");
        if (this.isReadOnly()) {
            this.syntax.append("border: 1 solid rgb(255,255,255); ");
        }
        if (this.getTextAlign() != null) {
            this.syntax.append("text-align:").append(this.getTextAlign()).append(";");
        }
        if (this.getColor() != null) {
            this.syntax.append(" color:").append(this.getColor()).append(";");
        }
        if (this.getBgcolor() != null) {
            this.syntax.append(" background-color:").append(this.getBgcolor()).append(";");
        }
        this.syntax.append("\"");
        if (this.getAction() != null) {
            this.syntax.append(" ").append(this.getAction());
        }
        if (this.isReadOnly()) {
            this.syntax.append(" readOnly");
        }
        if (this.isMultiselect()) {
            this.syntax.append(" multiple");
        }
        this.syntax.append(">");
        this.generateOptions(this.syntax);
        this.syntax.append("\n</select>");
        return this.syntax.toString();
    }

    private void generateOptions(StringBuilder output) {
        int iSelected = -1;
        Iterator<Integer> iterSelected = this.selected.iterator();
        if (iterSelected.hasNext()) {
            iSelected = iterSelected.next();
        }
        for (int i = 0; i < this.labels.size(); ++i) {
            output.append("\n<option value=\"").append(this.values.get(i)).append("\"");
            if (i == iSelected) {
                output.append(" selected");
                if (iterSelected.hasNext()) {
                    iSelected = iterSelected.next();
                }
            }
            output.append(">").append(this.labels.get(i)).append("</option>");
        }
    }
}

