/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.treemenu.process;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.controller.SilverpeasWebUtil;
import org.silverpeas.core.web.treemenu.model.MenuItem;
import org.silverpeas.core.web.treemenu.model.NodeType;
import org.silverpeas.core.web.treemenu.process.TreeBuilder;
import org.silverpeas.core.web.treemenu.process.TreeFilterFactory;
import org.silverpeas.core.web.treemenu.process.TreeMenuJSON;
import org.silverpeas.kernel.util.StringUtil;

public class TreeHandler {
    private TreeHandler() {
    }

    public static String processMenu(HttpServletRequest request, String menuType, boolean useCurrentOrder) {
        SilverpeasWebUtil webUtil = (SilverpeasWebUtil)ServiceProvider.getService(SilverpeasWebUtil.class, (Annotation[])new Annotation[0]);
        MainSessionController mainSessionCtrl = webUtil.getMainSessionController(request);
        String userId = mainSessionCtrl.getUserId();
        String language = mainSessionCtrl.getFavoriteLanguage();
        TreeBuilder builder = new TreeBuilder(userId, language, useCurrentOrder);
        MenuItem items = builder.buildLevelMenu(TreeFilterFactory.getTreeFilter(menuType), TreeHandler.getMenuItemFather(request));
        return TreeMenuJSON.getListAsJSONArray(items.getChildren());
    }

    private static MenuItem getMenuItemFather(HttpServletRequest request) {
        String key = request.getParameter("key");
        MenuItem father = null;
        if (StringUtil.isDefined((String)key)) {
            String componentId = request.getParameter("compoId");
            String levelMenu = request.getParameter("level");
            String leaf = request.getParameter("leaf");
            boolean isLeaf = false;
            if (StringUtil.isDefined((String)leaf)) {
                isLeaf = Boolean.parseBoolean(leaf);
            }
            int level = -1;
            if (StringUtil.isDefined((String)levelMenu)) {
                level = Integer.parseInt(levelMenu);
            }
            NodeType type = null;
            if (StringUtil.isDefined((String)request.getParameter("ntype"))) {
                type = NodeType.valueOf(request.getParameter("ntype"));
            }
            father = new MenuItem(null, key, level, type, isLeaf, null, componentId);
        }
        return father;
    }
}

