/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.subscription.bean;

import java.util.Date;
import org.silverpeas.core.admin.component.model.ComponentInstLight;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.space.SpaceInstLight;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.GroupDetail;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionSubscriber;
import org.silverpeas.core.subscription.constant.CommonSubscriptionResourceConstants;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.constant.SubscriptionMethod;
import org.silverpeas.core.util.URLUtil;

public abstract class AbstractSubscriptionBean
implements Subscription {
    private final Subscription subscription;
    private final String language;
    private UserDetail user = null;
    private Group group = null;
    private SpaceInstLight space = null;
    private SilverpeasComponentInstance component;

    protected AbstractSubscriptionBean(Subscription subscription, SilverpeasComponentInstance component, String language) {
        this.subscription = subscription;
        this.component = component;
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public SubscriptionResource getResource() {
        return this.subscription.getResource();
    }

    public SubscriptionSubscriber getSubscriber() {
        return this.subscription.getSubscriber();
    }

    public SubscriptionMethod getSubscriptionMethod() {
        return this.subscription.getSubscriptionMethod();
    }

    public String getCreatorId() {
        return this.subscription.getCreatorId();
    }

    public Date getCreationDate() {
        return this.subscription.getCreationDate();
    }

    public boolean isReadOnly() {
        return SubscriberType.GROUP.equals((Object)this.getSubscriber().getType());
    }

    public boolean isValid() {
        SubscriptionSubscriber subscriber = this.getSubscriber();
        SubscriptionResource resource = this.getResource();
        if (subscriber.getType() == SubscriberType.USER) {
            return this.isUserCanAccess(subscriber.getId(), resource);
        }
        if (subscriber.getType() == SubscriberType.GROUP) {
            return this.isGroupCanAccess(subscriber.getId(), resource);
        }
        return true;
    }

    protected boolean isUserCanAccess(String userId, SubscriptionResource resource) {
        boolean accessOK;
        if (resource.getType() == CommonSubscriptionResourceConstants.NODE) {
            NodePK nodePK = new NodePK(resource.getId(), resource.getInstanceId());
            accessOK = NodeAccessControl.get().isUserAuthorized(userId, (Object)nodePK);
        } else {
            accessOK = ComponentAccessControl.get().isUserAuthorized(userId, (Object)resource.getInstanceId());
        }
        return accessOK;
    }

    protected boolean isGroupCanAccess(String groupId, SubscriptionResource resource) {
        boolean accessOK;
        if (resource.getType() == CommonSubscriptionResourceConstants.NODE) {
            NodePK nodePK = new NodePK(resource.getId(), resource.getInstanceId());
            accessOK = NodeAccessControl.get().isGroupAuthorized(groupId, (Object)nodePK);
        } else {
            String instanceId = resource.getInstanceId();
            accessOK = ComponentAccessControl.get().isGroupAuthorized(groupId, (Object)instanceId);
        }
        return accessOK;
    }

    public String getPath() {
        return this.getSpace().getName() + " > " + this.getComponent().getLabel();
    }

    public String getLink() {
        return URLUtil.getSimpleURL((int)1, (String)this.subscription.getResource().getInstanceId());
    }

    public String getSubscriberName() {
        switch (this.getSubscriber().getType()) {
            case USER: {
                return this.getUser().getDisplayedName();
            }
            case GROUP: {
                return this.getGroup().getName();
            }
        }
        return "";
    }

    protected UserDetail getUser() {
        if (this.user == null) {
            this.user = UserDetail.getById((String)this.getSubscriber().getId());
            if (this.user == null) {
                this.user = new UserDetail();
            }
        }
        return this.user;
    }

    protected Group getGroup() {
        if (this.group == null) {
            this.group = OrganizationControllerProvider.getOrganisationController().getGroup(this.getSubscriber().getId());
            if (this.group == null) {
                this.group = new GroupDetail();
            }
        }
        return this.group;
    }

    public SilverpeasComponentInstance getComponent() {
        if (this.component == null) {
            this.component = OrganizationControllerProvider.getOrganisationController().getComponentInstance(this.subscription.getResource().getInstanceId()).orElseGet(ComponentInstLight::new);
        }
        return this.component;
    }

    public SpaceInstLight getSpace() {
        if (this.space == null) {
            this.space = OrganizationControllerProvider.getOrganisationController().getSpaceInstLightById(this.component.getSpaceId());
            if (this.space == null) {
                this.space = new SpaceInstLight();
            }
        }
        return this.space;
    }
}

