/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.session;

import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.notification.sse.CommonServerEvent;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.sse.behavior.AfterSentToAllContexts;
import org.silverpeas.core.notification.sse.behavior.KeepAlwaysLastStored;
import org.silverpeas.core.notification.sse.behavior.SendEveryAmountOfTime;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.util.JSONCodec;

public class UserSessionServerEvent
extends CommonServerEvent
implements KeepAlwaysLastStored,
AfterSentToAllContexts,
SendEveryAmountOfTime {
    private static final Object DATA_MUTEX = new Object();
    private static final String NB_CONNECTED_USERS_ATTR_NAME = "nbConnectedUsers";
    private static final ServerEvent.ServerEventName EVENT_NAME = () -> "USER_SESSION";
    private final SessionInfo emitterSession;
    private final boolean opening;
    private final SessionManagement sessionManagement;
    private String data = null;
    private boolean waitingFor = false;

    private UserSessionServerEvent(boolean opening, SessionInfo emitterSession) {
        this.emitterSession = emitterSession;
        this.opening = opening;
        this.sessionManagement = SessionManagementProvider.getSessionManagement();
    }

    static UserSessionServerEvent anOpeningOneFor(SessionInfo sessionInfo) {
        return new UserSessionServerEvent(true, sessionInfo).initializeData();
    }

    static UserSessionServerEvent aClosingOneFor(SessionInfo sessionInfo) {
        return new UserSessionServerEvent(false, sessionInfo).initializeData();
    }

    public boolean hasWaitingFor() {
        return this.waitingFor;
    }

    public void markAsWaitingFor() {
        this.waitingFor = true;
    }

    public ServerEvent.ServerEventName getName() {
        return EVENT_NAME;
    }

    public String subType() {
        UserDetail emitter = this.emitterSession.getUserDetail();
        return emitter.isDomainRestricted() ? "DOM" + emitter.getDomainId() : "";
    }

    public boolean isConcerned(String receiverSessionId, User receiver) {
        UserDetail emitter = this.emitterSession.getUserDetail();
        return !(this.opening && this.emitterSession.getSessionId().equals(receiverSessionId) || emitter.isDomainRestricted() && !emitter.getDomainId().equals(receiver.getDomainId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getData(String receiverSessionId, User receiver) {
        Object object = DATA_MUTEX;
        synchronized (object) {
            if (this.data == null) {
                this.data = super.getData(receiverSessionId, receiver);
            }
        }
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAllContexts() {
        Object object = DATA_MUTEX;
        synchronized (object) {
            this.data = null;
        }
    }

    private UserSessionServerEvent initializeData() {
        this.withData((receiverSessionId, receiver) -> {
            int nbConnectedUsers = this.sessionManagement.getNbConnectedUsersList(receiver) - 1;
            return JSONCodec.encodeObject(jsonObject -> jsonObject.put(NB_CONNECTED_USERS_ATTR_NAME, Integer.valueOf(nbConnectedUsers)));
        });
        return this;
    }
}

