/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.silverpeas.core.admin.component.model.ComponentInst;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.ProfileInst;
import org.silverpeas.core.admin.user.model.UserDetail;

public class SelectionUsersGroups {
    static OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
    public static final int USER = 0;
    public static final int GROUP = 1;
    private boolean includeRemovedUsers = false;
    private String domainId = null;
    private String componentId = null;
    private String objectId = null;
    private List<String> profileIds = null;
    private List<String> profileNames = null;
    private boolean matchingAllProfileNames = false;

    public String getJoinedProfileNames() {
        if (this.profileNames != null && !this.profileNames.isEmpty()) {
            return String.join((CharSequence)",", this.profileNames);
        }
        return null;
    }

    public boolean isMatchingAllProfileNames() {
        return this.matchingAllProfileNames;
    }

    public List<String> getProfileIds() {
        return this.profileIds;
    }

    public void setProfileNames(List<String> profileNames) {
        this.setProfileNames(profileNames, false);
    }

    public void setProfileNames(List<String> profileNames, boolean matchingAll) {
        this.profileNames = profileNames;
        this.matchingAllProfileNames = matchingAll;
        ComponentInst componentInst = organizationController.getComponentInst(this.componentId);
        this.profileIds = new ArrayList<String>();
        for (ProfileInst profileInst : componentInst.getAllProfilesInst()) {
            if (!profileNames.contains(profileInst.getName())) continue;
            this.profileIds.add(profileInst.getId());
        }
    }

    public boolean isIncludeRemovedUsers() {
        return this.includeRemovedUsers;
    }

    public void setIncludeRemovedUsers(boolean includeRemovedUsers) {
        this.includeRemovedUsers = includeRemovedUsers;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public static String[] getDistinctUserIds(String[] selectedUsers, String[] selectedGroups) {
        HashSet<String> usersSet = new HashSet<String>();
        if (selectedUsers != null && selectedUsers.length > 0) {
            Collections.addAll(usersSet, selectedUsers);
        }
        if (selectedGroups != null && selectedGroups.length > 0) {
            for (String selectedGroup : selectedGroups) {
                UserDetail[] groupUsers;
                for (UserDetail groupUser : groupUsers = (UserDetail[])organizationController.getAllUsersOfGroup(selectedGroup)) {
                    usersSet.add(groupUser.getId());
                }
            }
        }
        return usersSet.toArray(new String[usersSet.size()]);
    }

    public static UserDetail[] getUserDetails(String[] userIds) {
        return (UserDetail[])organizationController.getUserDetails(userIds);
    }

    public static Group[] getGroups(String[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            Group[] result = new Group[groupIds.length];
            for (int g = 0; g < groupIds.length; ++g) {
                result[g] = organizationController.getGroup(groupIds[g]);
            }
            return result;
        }
        return new Group[0];
    }

    public static String[] getUserIds(UserDetail[] users) {
        if (users == null) {
            return new String[0];
        }
        String[] result = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            result[i] = users[i].getId();
        }
        return result;
    }

    public static String[] getGroupIds(Group[] groups) {
        if (groups == null) {
            return new String[0];
        }
        String[] result = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            result[i] = groups[i].getId();
        }
        return result;
    }
}

