/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.selection;

import java.util.Collection;
import java.util.List;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.web.selection.SelectionUsersGroups;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public final class Selection {
    public static final String USER_SELECTION_PANEL_PATH = "/selection/jsp/userpanel.jsp";
    public static final String TYPE_SELECTED_SET = "Set";
    public static final String TYPE_SELECTED_ELEMENT = "Element";
    protected List<Domain> registeredServerDomains;
    protected String goBackURL;
    protected String cancelURL;
    protected String htmlFormName;
    protected String htmlFormElementName;
    protected String htmlFormElementId;
    protected String htmlFormElementType;
    protected String[] selectedSets;
    protected String[] selectedElements;
    protected boolean popupMode;
    protected boolean multiSelect;
    protected boolean setSelectable;
    protected boolean elementSelectable;
    protected String hostSpaceName;
    protected Pair<String, String> hostComponentName;
    protected Pair<String, String>[] hostPath;
    protected SelectionUsersGroups extraParams;
    protected int selectedUserLimit;
    protected boolean filterOnDeactivatedState = true;

    public Selection() {
        this.resetAll();
    }

    public void resetAll() {
        this.registeredServerDomains = null;
        this.goBackURL = "";
        this.cancelURL = "";
        this.htmlFormName = "";
        this.htmlFormElementId = "";
        this.htmlFormElementName = "";
        this.selectedSets = new String[0];
        this.selectedElements = new String[0];
        this.popupMode = false;
        this.multiSelect = true;
        this.setSelectable = true;
        this.elementSelectable = true;
        this.hostSpaceName = "";
        this.hostComponentName = new Pair((Object)"", (Object)"");
        this.hostPath = new Pair[0];
        this.extraParams = null;
        this.selectedUserLimit = 0;
        this.filterOnDeactivatedState = true;
    }

    public static String getSelectionURL() {
        return USER_SELECTION_PANEL_PATH;
    }

    public void setHostSpaceName(String hostSpaceName) {
        this.hostSpaceName = hostSpaceName != null ? hostSpaceName : "";
    }

    public String getHostSpaceName() {
        return this.hostSpaceName;
    }

    public void setHostComponentName(Pair<String, String> hostComponentName) {
        this.hostComponentName = hostComponentName != null ? hostComponentName : new Pair((Object)"", (Object)"");
    }

    public Pair<String, String> getHostComponentName() {
        return this.hostComponentName;
    }

    public void setHostPath(Pair<String, String>[] hostPath) {
        this.hostPath = hostPath != null ? (Pair[])hostPath.clone() : new Pair[0];
    }

    public Pair<String, String>[] getHostPath() {
        return this.hostPath;
    }

    public String getCancelURL() {
        return this.cancelURL;
    }

    public void setCancelURL(String cancelURL) {
        this.cancelURL = cancelURL != null ? cancelURL : "";
    }

    public String getGoBackURL() {
        return this.goBackURL;
    }

    public void setGoBackURL(String goBackURL) {
        this.goBackURL = goBackURL;
    }

    public boolean isPopupMode() {
        return this.popupMode;
    }

    public void setPopupMode(boolean popupMode) {
        this.popupMode = popupMode;
    }

    public boolean isHotSetting() {
        return StringUtil.isDefined((String)this.htmlFormName);
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isSetSelectable() {
        return this.setSelectable;
    }

    public void setSetSelectable(boolean setSelectable) {
        this.setSelectable = setSelectable;
    }

    public boolean isElementSelectable() {
        return this.elementSelectable;
    }

    public void setElementSelectable(boolean elementSelectable) {
        this.elementSelectable = elementSelectable;
    }

    public String[] getSelectedElements() {
        return this.selectedElements;
    }

    public void setSelectedElements(String[] selectedElements) {
        this.selectedElements = selectedElements != null ? (String[])selectedElements.clone() : new String[0];
    }

    public void setSelectedElements(Collection<String> selectedElements) {
        if (selectedElements != null) {
            this.setSelectedElements(selectedElements.toArray(new String[selectedElements.size()]));
        } else {
            this.setSelectedElements((String[])null);
        }
    }

    public String getFirstSelectedElement() {
        if (this.selectedElements != null && this.selectedElements.length > 0 && StringUtil.isDefined((String)this.selectedElements[0])) {
            return this.selectedElements[0];
        }
        return null;
    }

    public String[] getSelectedSets() {
        return this.selectedSets;
    }

    public void setSelectedSets(String[] selectedSets) {
        this.selectedSets = selectedSets != null ? (String[])selectedSets.clone() : new String[0];
    }

    public void setSelectedSets(Collection<String> selectedSets) {
        if (selectedSets != null) {
            this.setSelectedSets(selectedSets.toArray(new String[selectedSets.size()]));
        } else {
            this.setSelectedSets((String[])null);
        }
    }

    public String getFirstSelectedSet() {
        if (this.selectedSets != null && this.selectedSets.length > 0 && StringUtil.isDefined((String)this.selectedSets[0])) {
            return this.selectedSets[0];
        }
        return null;
    }

    public SelectionUsersGroups getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(SelectionUsersGroups extraParams) {
        this.extraParams = extraParams;
    }

    public String getHtmlFormElementId() {
        return this.htmlFormElementId;
    }

    public void setHtmlFormElementId(String formElementId) {
        this.htmlFormElementId = formElementId;
    }

    public String getHtmlFormElementName() {
        return this.htmlFormElementName;
    }

    public void setHtmlFormElementName(String formElementName) {
        this.htmlFormElementName = formElementName;
    }

    public String getHtmlFormName() {
        return this.htmlFormName;
    }

    public void setHtmlFormName(String formName) {
        this.htmlFormName = formName;
    }

    public String getHtmlFormElementType() {
        return this.htmlFormElementType;
    }

    public void setHtmlFormElementType(String formElementType) {
        this.htmlFormElementType = formElementType;
    }

    public int getSelectedUserLimit() {
        return this.selectedUserLimit;
    }

    public void setSelectedUserLimit(int selectedUserLimit) {
        this.selectedUserLimit = selectedUserLimit;
    }

    public List<Domain> getRegisteredServerDomains() {
        if (this.registeredServerDomains == null) {
            this.registeredServerDomains = CollectionUtil.asList((Object[])OrganizationControllerProvider.getOrganisationController().getAllDomains());
        }
        return this.registeredServerDomains;
    }

    public boolean isFilterOnDeactivatedState() {
        return this.filterOnDeactivatedState;
    }

    public void setFilterOnDeactivatedState(boolean filterOnDeactivatedState) {
        this.filterOnDeactivatedState = filterOnDeactivatedState;
    }
}

