/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.webcomponent;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -2003173095753706593L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            super.service(request, response);
        }
        catch (HttpError httpError) {
            String msg = String.format("http error %s [%s] -> %s", httpError.errorCode, request.getRequestURI(), httpError.message);
            SilverLogger logger = SilverLogger.getLogger((Object)((Object)this));
            if (403 == httpError.errorCode) {
                logger.error(msg, new Object[0]);
            } else {
                logger.debug(msg, new Object[0]);
            }
            httpError.performResponse(response);
        }
    }

    protected UserSessionStatus existOpenedUserSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            String sessionId;
            MainSessionController mainSessionCtrl = (MainSessionController)session.getAttribute("SilverSessionController");
            boolean isDesktopControllerInSession = mainSessionCtrl != null;
            String string = sessionId = isDesktopControllerInSession ? mainSessionCtrl.getSessionId() : session.getId();
            if (sessionId != null) {
                SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
                SessionInfo sessionInfo = sessionManagement.getSessionInfo(sessionId);
                boolean valid = sessionInfo.isDefined() && !sessionInfo.isAnonymous();
                return new UserSessionStatus(valid, isDesktopControllerInSession, sessionInfo);
            }
        }
        return new UserSessionStatus();
    }

    protected void redirectOrForwardService(HttpServletRequest request, HttpServletResponse response, String destination) throws ServletException, IOException {
        if (destination.startsWith("http") || destination.startsWith("ftp")) {
            response.sendRedirect(response.encodeRedirectURL(destination));
        } else {
            RequestDispatcher requestDispatcher = request.getRequestDispatcher(destination);
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void throwHttpPreconditionFailedError() {
        throw this.preconditionFailed("");
    }

    protected void throwHttpForbiddenError() {
        throw this.forbidden("");
    }

    protected void throwHttpNotFoundError() {
        throw this.notFound("");
    }

    protected void throwHttpPreconditionFailedError(String message) {
        throw this.preconditionFailed(message);
    }

    protected void throwHttpForbiddenError(String message) {
        throw this.forbidden(message);
    }

    protected void throwHttpNotFoundError(String message) {
        throw this.notFound(message);
    }

    protected void sendError(HttpServletResponse response, int status) {
        this.sendError(response, status, null);
    }

    protected void sendError(HttpServletResponse response, int status, String message) {
        try {
            if (StringUtil.isDefined((String)message)) {
                response.sendError(status, message);
            } else {
                response.sendError(status);
            }
        }
        catch (IOException e1) {
            SilverLogger.getLogger((Object)((Object)this)).error((Throwable)e1);
        }
    }

    protected HttpError preconditionFailed(String msg) {
        HttpError error = StringUtil.isDefined((String)msg) ? new HttpError(412, msg) : new HttpError(412);
        return error;
    }

    protected HttpError forbidden(String msg) {
        HttpError error = StringUtil.isDefined((String)msg) ? new HttpError(403, msg) : new HttpError(403);
        return error;
    }

    protected HttpError notFound(String msg) {
        HttpError error = StringUtil.isDefined((String)msg) ? new HttpError(404, msg) : new HttpError(404);
        return error;
    }

    protected static class HttpError
    extends RuntimeException {
        private static final long serialVersionUID = -4303217388313620495L;
        private final int errorCode;
        private final String message;

        HttpError(int errorCode) {
            this.errorCode = errorCode;
            this.message = null;
        }

        HttpError(int errorCode, String message) {
            this.errorCode = errorCode;
            this.message = message;
        }

        void performResponse(HttpServletResponse response) throws IOException {
            response.sendError(this.errorCode, this.message);
        }
    }

    protected static class UserSessionStatus {
        private final boolean valid;
        private final boolean fromDesktop;
        private final SessionInfo info;

        private UserSessionStatus() {
            this(false, false, null);
        }

        private UserSessionStatus(boolean valid, boolean fromDesktop, SessionInfo info) {
            this.valid = valid;
            this.fromDesktop = fromDesktop;
            this.info = info;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isFromDesktop() {
            return this.fromDesktop;
        }

        public SessionInfo getInfo() {
            return this.info;
        }
    }
}

