/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.export;

import java.io.IOException;
import java.io.Writer;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.date.TemporalFormatter;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.MemoizedSupplier;
import org.silverpeas.core.util.csv.CSVRow;
import org.silverpeas.core.web.http.FileResponse;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.http.PreparedDownload;
import org.silverpeas.kernel.util.StringUtil;

public class ExportCSVBuilder {
    private static final String LINE_SEPARATOR = "\n";
    private static final String FIELD_SEPARATOR = ";";
    private static final String EXPORT_ENCODING_DEFAULT = Charsets.UTF_8.name();
    private static final String REQUEST_ATTRIBUTE_NAME = "ExportCSVBuilder";
    private CSVRow header;
    private final List<CSVRow> rows = new ArrayList<CSVRow>();

    public static Optional<ExportCSVBuilder> getFrom(HttpRequest request) {
        return Optional.ofNullable(request.getAttribute(REQUEST_ATTRIBUTE_NAME)).map(ExportCSVBuilder.class::cast);
    }

    public String setupRequest(HttpRequest request) {
        request.setAttribute(REQUEST_ATTRIBUTE_NAME, (Object)this);
        return "/Export";
    }

    public void setHeader(CSVRow header) {
        this.header = header;
    }

    public void addLine(CSVRow row) {
        if (row != null && !row.isEmpty()) {
            this.rows.add(row);
        }
    }

    public void addLines(List<CSVRow> rows) {
        for (CSVRow row : rows) {
            this.addLine(row);
        }
    }

    protected void sendTo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filename = "export_data_" + System.currentTimeMillis() + ".csv";
        String contentType = "text/csv";
        Optional<PreparedDownload> preparedDownload = PreparedDownload.getPreparedDownloadToPerform(request, filename, "text/csv");
        if (preparedDownload.isPresent()) {
            try (Writer out = preparedDownload.get().getWriter(EXPORT_ENCODING_DEFAULT);){
                this.writeTo(out);
            }
            preparedDownload.get().sendDetails(response);
        } else {
            response.setContentType("text/csv");
            response.setCharacterEncoding(EXPORT_ENCODING_DEFAULT);
            response.setHeader("Content-Disposition", FileResponse.encodeAttachmentFilenameAsUtf8(filename));
            this.writeTo(response.getWriter());
        }
    }

    private void writeTo(Writer out) throws IOException {
        boolean isHeader;
        boolean bl = isHeader = this.header != null && !this.header.isEmpty();
        if (isHeader || !this.rows.isEmpty()) {
            out.write("\ufeff");
        }
        if (isHeader) {
            out.append(this.buildCSVRow(this.header)).append(LINE_SEPARATOR);
        }
        for (CSVRow row : this.rows) {
            out.append(this.buildCSVRow(row)).append(LINE_SEPARATOR);
        }
    }

    private String buildCSVRow(CSVRow row) {
        return row.stream().map(this::formatCSVValue).collect(Collectors.joining(FIELD_SEPARATOR));
    }

    private String formatCSVValue(Object value) {
        String str;
        if (value == null) {
            return "";
        }
        MemoizedSupplier userLanguage = new MemoizedSupplier(() -> User.getCurrentRequester().getUserPreferences().getLanguage());
        MemoizedSupplier userZoneId = new MemoizedSupplier(() -> User.getCurrentRequester().getUserPreferences().getZoneId());
        if (value instanceof String) {
            str = this.stringValue((String)value);
        } else if (value instanceof Integer) {
            str = Integer.toString((Integer)value);
        } else if (value instanceof Float) {
            str = Float.toString(((Float)value).floatValue());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            str = TemporalFormatter.toLocalized((Temporal)date.toInstant(), (String)((String)userLanguage.get()));
        } else if (value instanceof User) {
            User user = (User)value;
            str = this.stringValue(user.getLastName() + " " + user.getFirstName());
        } else if (value instanceof Temporal) {
            Temporal temporal = (Temporal)value;
            str = TemporalFormatter.toLocalized((Temporal)temporal, (ZoneId)((ZoneId)userZoneId.get()), (String)((String)userLanguage.get()));
        } else {
            str = this.stringValue(value.toString());
        }
        return str;
    }

    private String stringValue(String value) {
        return "\"" + StringUtil.defaultStringIfNotDefined((String)value).replace("\"", "\"\"").replaceAll("(?i)< *br */ *>", LINE_SEPARATOR) + "\"";
    }
}

