/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar.subscription.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.subscription.CalendarSubscriptionConstants;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.web.calendar.subscription.bean.CalendarSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBeanService;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;

@Service
public class CalendarSubscriptionBeanService
extends AbstractSubscriptionBeanService {
    @Override
    protected List<SubscriptionResourceType> getHandledSubscriptionResourceTypes() {
        return Stream.of(CalendarSubscriptionConstants.CALENDAR).collect(Collectors.toList());
    }

    @Override
    public String getSubscriptionTypeListLabel(SubscriptionResourceType type, String language) {
        Optional<String> label = CalendarSubscriptionConstants.CALENDAR.equals(type) ? Optional.of(this.getBundle(language).getString("calendar.label.calendars")) : Optional.empty();
        return label.orElse("");
    }

    @Override
    public List<AbstractSubscriptionBean> toSubscriptionBean(Collection<Subscription> subscriptions, String language) {
        OrganizationController controller = OrganizationController.get();
        ArrayList<AbstractSubscriptionBean> converted = new ArrayList<AbstractSubscriptionBean>();
        for (Subscription subscription : subscriptions) {
            SubscriptionResource resource = subscription.getResource();
            SubscriptionResourceType type = resource.getType();
            if (!CalendarSubscriptionConstants.CALENDAR.equals(type)) continue;
            controller.getComponentInstance(resource.getInstanceId()).ifPresent(i -> {
                Calendar calendar = Calendar.getById((String)resource.getId());
                if (calendar != null && calendar.getComponentInstanceId().equals(resource.getInstanceId())) {
                    converted.add(new CalendarSubscriptionBean(subscription, calendar, (SilverpeasComponentInstance)i, language));
                }
            });
        }
        return converted;
    }

    @Override
    protected LocalizationBundle getBundle(String language) {
        return ResourceLocator.getLocalizationBundle((String)"org.silverpeas.calendar.multilang.calendarBundle", (String)language);
    }
}

