/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.date.period.Period;
import org.silverpeas.core.date.period.PeriodType;
import org.silverpeas.core.web.calendar.CalendarDateTime;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class CalendarPeriod {
    private Period period;
    private CalendarDateTime beginDate;
    private CalendarDateTime endDate;

    public static CalendarPeriod from(Date referenceDate, PeriodType periodType, String locale) {
        return CalendarPeriod.from(Period.from((Date)referenceDate, (PeriodType)periodType, (String)locale), locale);
    }

    public static CalendarPeriod from(Period period, String locale) {
        return new CalendarPeriod(period, locale);
    }

    private CalendarPeriod(Period period, String locale) {
        this.period = period;
        this.beginDate = new CalendarDateTime(period.getBeginDate(), locale);
        this.endDate = new CalendarDateTime(period.getEndDate(), locale);
    }

    public PeriodType getPeriodType() {
        return this.period.getPeriodType();
    }

    public CalendarDateTime getBeginDate() {
        return this.beginDate;
    }

    public CalendarDateTime getEndDate() {
        return this.endDate;
    }
}

