/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.calendar;

import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.component.model.PersonalComponentInstance;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.calendar.CalendarEventOccurrence;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.calendar.AbstractCalendarWebRequestContext;
import org.silverpeas.core.web.calendar.CalendarTimeWindowViewContext;
import org.silverpeas.core.web.calendar.CalendarViewType;
import org.silverpeas.core.web.mvc.controller.ComponentContext;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentController;
import org.silverpeas.core.web.mvc.webcomponent.WebComponentRequestContext;
import org.silverpeas.core.web.mvc.webcomponent.annotation.LowestRoleAccess;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectTo;
import org.silverpeas.core.web.mvc.webcomponent.annotation.RedirectToInternal;
import org.silverpeas.core.web.selection.Selection;
import org.silverpeas.core.web.selection.SelectionUsersGroups;
import org.silverpeas.core.webapi.calendar.CalendarEventOccurrenceEntity;
import org.silverpeas.core.webapi.calendar.CalendarWebManager;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.Pair;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractCalendarWebController<C extends AbstractCalendarWebRequestContext>
extends WebComponentController<C> {
    private static final int STRING_MAX_LENGTH = 50;
    private Selection userPanelSelection = this.getSelection();

    public AbstractCalendarWebController(MainSessionController controller, ComponentContext context, String multilangFileName, String iconFileName, String settingsFileName) {
        super(controller, context, multilangFileName, iconFileName, settingsFileName);
    }

    protected abstract <T extends CalendarTimeWindowViewContext> T getCalendarTimeWindowContext();

    @POST
    @Path(value="calendars/context")
    @Produces(value={"application/json"})
    public <T extends CalendarTimeWindowViewContext> T view(C context) {
        String timeWindow;
        String listViewMode;
        CalendarViewType calendarViewType = CalendarViewType.from(((WebComponentRequestContext)context).getRequest().getParameter("view"));
        if (calendarViewType != null) {
            ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).setViewType(calendarViewType);
        }
        if (StringUtil.isDefined((String)(listViewMode = ((WebComponentRequestContext)context).getRequest().getParameter("listViewMode")))) {
            ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).setListViewMode(StringUtil.getBooleanValue((String)listViewMode));
        }
        if (StringUtil.isDefined((String)(timeWindow = ((WebComponentRequestContext)context).getRequest().getParameter("timeWindow")))) {
            if ("previous".equals(timeWindow)) {
                ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).previous();
            } else if ("next".equals(timeWindow)) {
                ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).next();
            } else if ("today".equals(timeWindow)) {
                ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).today();
            } else if ("referenceDay".equals(timeWindow)) {
                LocalDate date = LocalDate.parse(((WebComponentRequestContext)context).getRequest().getParameter("timeWindowDate").split("T")[0]);
                ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).setReferenceDay(Date.valueOf(date));
            }
        }
        return this.getCalendarTimeWindowContext();
    }

    @POST
    @Path(value="calendars/events/users/participation")
    @RedirectTo(value="{userPanelUri}")
    @LowestRoleAccess(value=SilverpeasRole.WRITER)
    public void viewParticipationOfUsers(C context) {
        List userIds = (List)StringUtil.splitString((String)((WebComponentRequestContext)context).getRequest().getParameter("UserPanelCurrentUserIds"), (char)',');
        List groupIds = (List)StringUtil.splitString((String)((WebComponentRequestContext)context).getRequest().getParameter("UserPanelCurrentGroupIds"), (char)',');
        String selectionUri = this.initSelection(this.getUserParticipationSelectionParams(), "userParticipation", userIds, groupIds);
        ((WebComponentRequestContext)context).addRedirectVariable("userPanelUri", selectionUri);
    }

    protected SelectionUsersGroups getUserParticipationSelectionParams() {
        SelectionUsersGroups attendeeSelectionParams = new SelectionUsersGroups();
        if (!PersonalComponentInstance.from((String)this.getComponentId()).isPresent()) {
            attendeeSelectionParams.setComponentId(this.getComponentId());
        }
        return attendeeSelectionParams;
    }

    @POST
    @Path(value="calendars/events/attendees/select")
    @RedirectTo(value="{userPanelUri}")
    @LowestRoleAccess(value=SilverpeasRole.WRITER)
    public void modifyAttendees(C context) {
        List userIds = (List)StringUtil.splitString((String)((WebComponentRequestContext)context).getRequest().getParameter("UserPanelCurrentUserIds"), (char)',');
        List groupIds = (List)StringUtil.splitString((String)((WebComponentRequestContext)context).getRequest().getParameter("UserPanelCurrentGroupIds"), (char)',');
        String selectionUri = this.initSelection(this.getAttendeeSelectionParams(), "attendees", userIds, groupIds);
        ((WebComponentRequestContext)context).addRedirectVariable("userPanelUri", selectionUri);
    }

    protected SelectionUsersGroups getAttendeeSelectionParams() {
        SelectionUsersGroups attendeeSelectionParams = new SelectionUsersGroups();
        if (!PersonalComponentInstance.from((String)this.getComponentId()).isPresent()) {
            attendeeSelectionParams.setComponentId(this.getComponentId());
        }
        return attendeeSelectionParams;
    }

    protected void processNewEvent(AbstractCalendarWebRequestContext context) {
        Temporal startDate = context.getOccurrenceStartDate();
        if (startDate != null) {
            context.getRequest().setAttribute("occurrenceStartDate", (Object)startDate.toString());
        }
    }

    protected void processViewOccurrence(AbstractCalendarWebRequestContext context, String navigationStepId) {
        CalendarEventOccurrence occurrence = context.getCalendarEventOccurrenceById();
        if (occurrence == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        CalendarEventOccurrenceEntity entity = CalendarEventOccurrenceEntity.fromOccurrence(occurrence, context.getComponentInstanceId(), ((CalendarTimeWindowViewContext)this.getCalendarTimeWindowContext()).getZoneId(), false).withOccurrenceURI(context.uri().ofOccurrence(occurrence));
        context.getRequest().setAttribute("occurrence", (Object)entity);
        context.getNavigationContext().navigationStepFrom(navigationStepId).withLabel(StringUtil.truncate((String)entity.getTitle(), (int)50)).withFullUri(context.uri().ofOccurrenceView(occurrence).getPath().replaceFirst(URLUtil.getApplicationURL(), ""));
    }

    private String initSelection(SelectionUsersGroups sug, String goFunction, List<String> userIds, List<String> groupIds) {
        String url = ResourceLocator.getGeneralSettingBundle().getString("ApplicationURL") + URLUtil.getURL((String)this.getSpaceId(), (String)this.getComponentId());
        String goUrl = url + goFunction;
        this.userPanelSelection.resetAll();
        this.userPanelSelection.setGoBackURL(goUrl);
        this.userPanelSelection.setElementSelectable(true);
        this.userPanelSelection.setSelectedElements(userIds);
        this.userPanelSelection.setSetSelectable(false);
        this.userPanelSelection.setSelectedSets(groupIds);
        this.userPanelSelection.setHostPath(null);
        Pair hostComponentName = new Pair((Object)this.getComponentLabel(), null);
        this.userPanelSelection.setHostComponentName((Pair<String, String>)hostComponentName);
        this.userPanelSelection.setHostSpaceName(this.getSpaceLabel());
        this.userPanelSelection.setPopupMode(true);
        this.userPanelSelection.setHtmlFormElementId(goFunction);
        this.userPanelSelection.setHtmlFormName("dummy");
        this.userPanelSelection.setExtraParams(sug);
        return Selection.getSelectionURL();
    }

    @GET
    @Path(value="searchResult")
    @RedirectToInternal(value="calendars/occurrences/{occurrenceId}")
    public void searchResult(AbstractCalendarWebRequestContext context) {
        context.getNavigationContext().clear();
        CalendarEventOccurrence occurrence = CalendarWebManager.get(this.getComponentName()).getFirstCalendarEventOccurrenceFromEventId(context.getRequest().getParameter("Id"));
        context.addRedirectVariable("occurrenceId", StringUtil.asBase64((byte[])occurrence.getId().getBytes()));
    }
}

