/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.security.authentication.exception.AuthenticationException;
import org.silverpeas.core.web.authentication.credentials.ChangePasswordFunctionHandler;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class EffectiveChangePasswordFromLoginHandler
extends ChangePasswordFunctionHandler {
    @Override
    public String getFunction() {
        return "EffectiveChangePasswordFromLogin";
    }

    @Override
    public String doAction(HttpServletRequest request) {
        String login = request.getParameter("login");
        String domainId = request.getParameter("domainId");
        String oldPassword = request.getParameter("oldPassword");
        String newPassword = request.getParameter("newPassword");
        String email = request.getParameter("emailAddress");
        String checkId = request.getParameter("checkId");
        AuthenticationCredential credential = null;
        try {
            this.assertPasswordHasBeenCorrectlyChecked(checkId, newPassword);
            credential = AuthenticationCredential.newWithAsLogin((String)login).withAsPassword(oldPassword).withAsDomainId(domainId);
            this.getAuthenticator().changePasswordAndEmail(credential, newPassword, email);
            return "/AuthenticationServlet?Login=" + login + "&Password=" + newPassword + "&DomainId=" + domainId;
        }
        catch (AuthenticationException e) {
            if (StringUtil.isDefined((String)email)) {
                request.setAttribute("isThatUserMustFillEmailAddressOnFirstLogin", (Object)true);
                request.setAttribute("emailAddress", (Object)email);
            }
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.lookAndFeel.generalLook");
            return this.performUrlChangePasswordError(request, settings.getString("changePasswordFromLoginPage") + "?Login=" + login + "&DomainId=" + domainId, credential);
        }
    }
}

