/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.notification.NotificationException;
import org.silverpeas.core.notification.user.client.NotificationMetaData;
import org.silverpeas.core.notification.user.client.NotificationSender;
import org.silverpeas.core.notification.user.client.UserRecipient;
import org.silverpeas.core.notification.user.client.constant.BuiltInNotifAddress;
import org.silverpeas.core.security.authentication.UserAuthenticationListener;
import org.silverpeas.core.security.authentication.UserAuthenticationListenerRegistration;
import org.silverpeas.core.security.session.SessionInfo;
import org.silverpeas.core.security.session.SessionManagement;
import org.silverpeas.core.security.session.SessionManagementProvider;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.token.SynchronizerTokenService;
import org.silverpeas.core.web.util.WebRedirection;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Bean
public class SilverpeasSessionOpener {
    SilverpeasSessionOpener() {
    }

    public String openSession(HttpRequest request, String authKey) {
        try {
            MainSessionController controller;
            SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
            HttpSession session = request.getSession(false);
            SessionInfo sessionInfo = sessionManagement.validateSession(session.getId());
            if (!sessionInfo.isDefined() || sessionInfo.isAnonymous()) {
                controller = new MainSessionController(authKey, session);
                controller.setAllowPasswordChange(this.isPasswordChangedAllowed(session));
                if (!controller.getCurrentUserDetail().isDeletedState() && !controller.getCurrentUserDetail().isDeactivatedState()) {
                    if (!UserDetail.isAnonymousUser((String)controller.getUserId())) {
                        sessionInfo = sessionManagement.openSession((User)controller.getCurrentUserDetail(), (HttpServletRequest)request);
                        this.registerSuccessfulConnexion(sessionInfo);
                        SynchronizerTokenService.getInstance().setUpSessionTokens(sessionInfo);
                    } else {
                        sessionManagement.openAnonymousSession((HttpServletRequest)request);
                    }
                }
            } else {
                controller = (MainSessionController)session.getAttribute("SilverSessionController");
            }
            String redirectURL = this.getAnyRedirection((HttpServletRequest)request, controller);
            return this.getHomePageUrl(request, redirectURL, true);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Session opening failure!", (Throwable)e);
            SilverLogger.getLogger((Object)this).error("No user found with the authentication key {0}", new Object[]{authKey});
            return this.getErrorPageUrl(request);
        }
    }

    private String getAnyRedirection(HttpServletRequest request, MainSessionController controller) {
        String redirectURL = this.notifyAboutPasswordExpiration(request, controller);
        if (StringUtil.isNotDefined((String)redirectURL)) {
            return new WebRedirection().getRedirectionURL(request);
        }
        return redirectURL;
    }

    String prepareFromExistingSessionInfo(HttpRequest request, SessionInfo sessionInfo) {
        HttpSession session = request.getSession(false);
        try {
            if (!sessionInfo.isDefined()) {
                throw new SilverpeasRuntimeException("session " + session.getId() + " is not defined");
            }
            MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
            if (controller != null) {
                controller = (MainSessionController)session.getAttribute("SilverSessionController");
            } else {
                controller = new MainSessionController(sessionInfo, session);
                if (!sessionInfo.isAnonymous()) {
                    controller.setAllowPasswordChange(this.isPasswordChangedAllowed(session));
                    this.registerSuccessfulConnexion(sessionInfo);
                }
            }
            String redirectURL = this.notifyAboutPasswordExpiration((HttpServletRequest)request, controller);
            return this.getHomePageUrl(request, redirectURL, true);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("Session opening failure!", (Throwable)e);
            SilverLogger.getLogger((Object)this).error("No user found with the session into {0}", new Object[]{sessionInfo.getSessionId()});
            return this.getErrorPageUrl(request);
        }
    }

    private String notifyAboutPasswordExpiration(HttpServletRequest request, MainSessionController controller) {
        HttpSession session = request.getSession(false);
        Boolean alertUserAboutPwdExpiration = (Boolean)session.getAttribute("Svp_Pwd_About_To_Expire");
        String redirectURL = null;
        if (alertUserAboutPwdExpiration != null && alertUserAboutPwdExpiration.booleanValue()) {
            redirectURL = this.alertUserAboutPwdExpiration(controller.getUserId(), OrganizationControllerProvider.getOrganisationController().getAdministratorUserIds(controller.getUserId())[0], controller.getFavoriteLanguage(), this.isPasswordChangedAllowed(session));
        }
        return redirectURL;
    }

    private boolean isPasswordChangedAllowed(HttpSession session) {
        return StringUtil.getBooleanValue((String)((String)session.getAttribute("Svp_Password_Change_Allowed")));
    }

    private void registerSuccessfulConnexion(SessionInfo sessionInfo) {
        UserDetail user = sessionInfo.getUserDetail();
        user.setLastLoginDate(DateUtil.getNow());
        user.setNbSuccessfulLoginAttempts(user.getNbSuccessfulLoginAttempts() + 1);
        AdminController adminController = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
        adminController.updateUser(user);
    }

    public void closeSession(HttpSession session) {
        if (session != null) {
            SessionManagement sessionManagement = SessionManagementProvider.getSessionManagement();
            sessionManagement.closeSession(session.getId());
        }
    }

    String getErrorPageUrl(HttpRequest request) {
        StringBuilder absoluteUrl = new StringBuilder(this.getAbsoluteUrl(request));
        if (absoluteUrl.charAt(absoluteUrl.length() - 1) != '/') {
            absoluteUrl.append('/');
        }
        absoluteUrl.append("Login");
        return absoluteUrl.toString();
    }

    String getHomePageUrl(HttpRequest request, String redirectURL, boolean isFirstSessionAccess) {
        String absoluteBaseURL = this.getAbsoluteUrl(request);
        StringBuilder absoluteUrl = new StringBuilder(absoluteBaseURL);
        HttpSession session = request.getSession(false);
        MainSessionController controller = (MainSessionController)session.getAttribute("SilverSessionController");
        String personalWs = controller.getPersonalization().getPersonalWorkSpaceId();
        GraphicElementFactory gef = new GraphicElementFactory(controller);
        if (StringUtil.isDefined((String)personalWs)) {
            gef.setSpaceIdForCurrentRequest(personalWs);
        }
        gef.setHttpRequest(request);
        session.setAttribute("SessionGraphicElementFactory", (Object)gef);
        String favoriteFrame = gef.getLookFrame();
        String sDirectAccessSpace = request.getParameter("DirectAccessSpace");
        String sDirectAccessCompo = request.getParameter("DirectAccessCompo");
        if (MainSessionController.isAppInMaintenance() && !controller.getCurrentUserDetail().isAccessAdmin()) {
            absoluteUrl.append("/admin/jsp/appInMaintenance.jsp");
        } else if (StringUtil.isDefined((String)redirectURL)) {
            absoluteUrl.append(redirectURL);
        } else if (StringUtil.isDefined((String)sDirectAccessSpace) && StringUtil.isDefined((String)sDirectAccessCompo)) {
            absoluteUrl.append(URLUtil.getURL((String)sDirectAccessSpace, (String)sDirectAccessCompo)).append("Main");
        } else {
            absoluteUrl.append("/Main/").append(favoriteFrame);
        }
        return this.performUserAuthenticationListener(request, controller, absoluteUrl.toString(), isFirstSessionAccess);
    }

    String getAbsoluteUrl(HttpRequest request) {
        StringBuilder absoluteUrl = new StringBuilder(256);
        if (request.isSecure()) {
            absoluteUrl.append("https://");
        } else {
            absoluteUrl.append("http://");
        }
        absoluteUrl.append(request.getServerName()).append(':');
        absoluteUrl.append(request.getServerPort());
        absoluteUrl.append(URLUtil.getApplicationURL());
        return absoluteUrl.toString();
    }

    private String alertUserAboutPwdExpiration(String userId, String fromUserId, String language, boolean allowPasswordChange) {
        try {
            SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.passwordExpiration");
            String notificationType = settings.getString("notificationType", "POPUP");
            String passwordChangeURL = settings.getString("passwordChangeURL", "defaultPasswordAboutToExpire.jsp");
            if ("POPUP".equalsIgnoreCase(notificationType) || !allowPasswordChange) {
                this.sendPopupNotificationAboutPwdExpiration(userId, fromUserId, language);
                return null;
            }
            return passwordChangeURL;
        }
        catch (NotificationException e) {
            SilverLogger.getLogger((Object)this).error("Cannot send the password expiration alert for user {0}", (Object[])new String[]{userId}, (Throwable)e);
            return null;
        }
    }

    private void sendPopupNotificationAboutPwdExpiration(String userId, String fromUserId, String language) throws NotificationException {
        LocalizationBundle messages = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.peasCore.multilang.peasCoreBundle", (String)language);
        NotificationSender sender = new NotificationSender(null);
        NotificationMetaData notifMetaData = new NotificationMetaData(0, messages.getString("passwordExpirationAlert"), messages.getString("passwordExpirationMessage"));
        notifMetaData.setSender(fromUserId);
        notifMetaData.addUserRecipient(new UserRecipient(userId));
        sender.notifyUser(BuiltInNotifAddress.BASIC_POPUP.getId(), notifMetaData);
    }

    private String performUserAuthenticationListener(HttpRequest request, MainSessionController controller, String homePageUrl, boolean isFirstSessionAccess) {
        String alternativeURL = null;
        for (UserAuthenticationListener listener : UserAuthenticationListenerRegistration.getListeners()) {
            String url = isFirstSessionAccess ? listener.firstHomepageAccessAfterAuthentication((HttpServletRequest)request, (User)controller.getCurrentUserDetail(), homePageUrl) : listener.homepageAccessFromLoginWhenUserSessionAlreadyOpened((HttpServletRequest)request, (User)controller.getCurrentUserDetail(), homePageUrl);
            if (!StringUtil.isDefined((String)url)) continue;
            alternativeURL = url;
        }
        if (StringUtil.isDefined(alternativeURL)) {
            return this.getAbsoluteUrl(request) + alternativeURL;
        }
        return homePageUrl;
    }

    public static SilverpeasSessionOpener getInstance() {
        return (SilverpeasSessionOpener)ServiceProvider.getService(SilverpeasSessionOpener.class, (Annotation[])new Annotation[0]);
    }
}

