/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.driver.admin;

import com.sun.portal.portletcontainer.driver.admin.PortletAdminData;
import com.sun.portal.portletcontainer.driver.admin.PortletAdminDataFactory;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortletWar {
    private File warFile;
    private File markerFile;
    private static Logger logger = Logger.getLogger(PortletWar.class.getPackage().getName(), "com.silverpeas.portlets.PCDLogMessages");
    protected static final int NUM_RETRIES = 3;

    public PortletWar(String portletWarFileName) {
        this(new File(portletWarFileName));
    }

    public PortletWar(File war) {
        this.warFile = war;
        this.markerFile = new File(this.warFile.getAbsolutePath() + ".deployed");
    }

    public void deploy() {
        if (this.isWarInValidState(this.warFile)) {
            boolean success = false;
            String absolutePath = this.warFile.getAbsolutePath();
            try {
                PortletAdminData portletAdminData = PortletAdminDataFactory.getPortletAdminData(null);
                success = portletAdminData.deploy(absolutePath, true);
                this.createDeployedMarkerFile();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "PSPCD_CSPPD0035", ex);
                try {
                    this.undeploy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void createDeployedMarkerFile() {
        try {
            this.markerFile.createNewFile();
        }
        catch (IOException e) {
            logger.log(Level.INFO, "PSPCD_CSPPD0037", new String[]{this.warFile.getAbsolutePath()});
        }
    }

    private boolean isWarInValidState(File file) {
        for (int i = 0; i < 3; ++i) {
            try {
                JarFile war = new JarFile(file);
                war.entries();
                war.close();
                return true;
            }
            catch (IOException e) {
                logger.log(Level.INFO, "PSPCD_CSPPD0036", new String[]{"" + i});
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    public boolean isDeployed() {
        return this.markerFile.exists();
    }

    public void undeploy() throws Exception {
        PortletAdminData portletAdminData = PortletAdminDataFactory.getPortletAdminData(null);
        portletAdminData.undeploy(this.getWarName(), true);
        if (this.markerFile.exists()) {
            this.markerFile.delete();
        }
    }

    public boolean warFileExists() {
        return this.warFile.exists();
    }

    public String getWarName() {
        String regexp = ".war$";
        return this.warFile.getName().replaceFirst(regexp, "");
    }

    public boolean needsRedeploy() {
        return this.warFile.lastModified() > this.markerFile.lastModified();
    }

    public void redeploy() throws Exception {
        this.undeploy();
        this.deploy();
    }
}

