/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portletcontainer.admin.registry;

import com.sun.portal.container.EntityID;
import com.sun.portal.container.PortletLang;
import com.sun.portal.container.PortletType;
import com.sun.portal.portletcontainer.admin.PortletRegistryElement;
import com.sun.portal.portletcontainer.admin.PortletRegistryHelper;
import com.sun.portal.portletcontainer.admin.PortletRegistryObject;
import com.sun.portal.portletcontainer.admin.PortletRegistryWriter;
import com.sun.portal.portletcontainer.admin.registry.PortletWindow;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryContext;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryReader;
import com.sun.portal.portletcontainer.admin.registry.PortletWindowRegistryWriter;
import com.sun.portal.portletcontainer.context.registry.PortletRegistryException;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.core.web.portlets.portal.PortletWindowData;

public class PortletWindowRegistryContextImpl
implements PortletWindowRegistryContext {
    PortletRegistryObject portletWindowRegistry;
    PortletRegistryObject defaultPortletWindowRegistry;
    String context;

    public PortletWindowRegistryContextImpl() throws PortletRegistryException {
        this.init(null);
    }

    public PortletWindowRegistryContextImpl(String context) throws PortletRegistryException {
        this.init(context);
    }

    private void init(String context) throws PortletRegistryException {
        this.context = context;
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        PortletWindowRegistryReader portletWindowRegistryReader = new PortletWindowRegistryReader(registryLocation, context);
        this.portletWindowRegistry = portletWindowRegistryReader.readDocument();
        portletWindowRegistryReader = new PortletWindowRegistryReader(registryLocation, null);
        this.defaultPortletWindowRegistry = portletWindowRegistryReader.readDocument();
    }

    private List<String> getAllPortletWindows(PortletType portletType, boolean allPortlets) throws PortletRegistryException {
        List<PortletRegistryElement> portletWindows = this.portletWindowRegistry.getRegistryElements();
        ArrayList<String> visiblePortletWindows = new ArrayList<String>();
        if (portletType == null) {
            portletType = PortletType.ALL;
        }
        for (PortletRegistryElement portletWindowElt : portletWindows) {
            PortletWindow portletWindow = (PortletWindow)portletWindowElt;
            String portletWindowName = portletWindow.getName();
            boolean isRemote = this.isRemote(portletWindowName);
            if (!portletType.equals((Object)PortletType.ALL) && (isRemote || !portletType.equals((Object)PortletType.LOCAL)) && (!isRemote || !portletType.equals((Object)PortletType.REMOTE)) || !allPortlets && !this.isVisible(portletWindowName)) continue;
            visiblePortletWindows.add(portletWindowName);
        }
        return visiblePortletWindows;
    }

    @Override
    public List<String> getVisiblePortletWindows(PortletType portletType) throws PortletRegistryException {
        return this.getAllPortletWindows(portletType, false);
    }

    @Override
    public List<String> getAllPortletWindows(PortletType portletType) throws PortletRegistryException {
        return this.getAllPortletWindows(portletType, true);
    }

    @Override
    public boolean isVisible(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String visibleValue = portletRegistryElement.getStringProperty("visible");
        return "true".equals(visibleValue);
    }

    @Override
    public EntityID getEntityId(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        return this.getEntityId(portletRegistryElement, portletWindowName);
    }

    private EntityID getEntityId(PortletRegistryElement portletRegistryElement, String portletWindowName) throws PortletRegistryException {
        String entityIDPrefix = this.getEntityIdPrefix(portletRegistryElement);
        EntityID entityID = new EntityID();
        entityID.setPrefix(entityIDPrefix);
        entityID.setPortletWindowName(portletWindowName);
        return entityID;
    }

    @Override
    public List<EntityID> getEntityIds() throws PortletRegistryException {
        List<PortletRegistryElement> portletWindows = this.portletWindowRegistry.getRegistryElements();
        ArrayList<EntityID> entityIds = new ArrayList<EntityID>();
        for (PortletRegistryElement portletWindowElt : portletWindows) {
            PortletWindow portletWindow = (PortletWindow)portletWindowElt;
            String portletWindowName = portletWindow.getName();
            entityIds.add(this.getEntityId(portletWindow, portletWindowName));
        }
        return entityIds;
    }

    private void setEntityIdPrefix(PortletRegistryElement portletRegistryElement, String entityID) throws PortletRegistryException {
        portletRegistryElement.setStringProperty("entityIDPrefix", entityID);
    }

    private void setWidth(PortletRegistryElement portletRegistryElement, String width, String row) throws PortletRegistryException {
        portletRegistryElement.setStringProperty("width", width);
        if (row != null) {
            portletRegistryElement.setStringProperty("row", row);
        }
    }

    private void setVisible(PortletRegistryElement portletRegistryElement, boolean value) throws PortletRegistryException {
        portletRegistryElement.setStringProperty("visible", Boolean.toString(value));
    }

    private String getEntityIdPrefix(PortletRegistryElement portletRegistryElement) throws PortletRegistryException {
        String entityIDPrefix = portletRegistryElement.getStringProperty("entityIDPrefix");
        return entityIDPrefix;
    }

    @Override
    public String getPortletWindowTitle(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        return this.getPortletWindowTitle(portletRegistryElement);
    }

    @Override
    public void setPortletWindowTitle(String portletWindowName, String title) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        this.setPortletWindowTitle(portletRegistryElement, title);
    }

    private String getPortletWindowTitle(PortletRegistryElement portletRegistryElement) throws PortletRegistryException {
        return portletRegistryElement.getStringProperty("title");
    }

    private void setPortletWindowTitle(PortletRegistryElement portletRegistryElement, String title) throws PortletRegistryException {
        portletRegistryElement.setStringProperty("title", title);
    }

    @Override
    public void createPortletWindow(String portletName, String portletWindowName) throws PortletRegistryException {
        this.createPortletWindow(portletName, portletWindowName, null, null);
    }

    @Override
    public void createPortletWindow(String portletName, String portletWindowName, String title, String locale) throws PortletRegistryException {
        PortletRegistryElement newPortletRegistryElement;
        PortletRegistryElement existingPortletRegistryElement = this.portletWindowRegistry.getRegistryElement(portletName);
        if (existingPortletRegistryElement == null) {
            existingPortletRegistryElement = this.defaultPortletWindowRegistry.getRegistryElement(portletName);
        }
        if ((newPortletRegistryElement = this.portletWindowRegistry.getRegistryElement(portletWindowName)) == null) {
            newPortletRegistryElement = new PortletWindow();
            newPortletRegistryElement.setName(portletWindowName);
            newPortletRegistryElement.setPortletName(existingPortletRegistryElement.getPortletName());
            newPortletRegistryElement.setUserName(this.context);
            this.setPortletWindowTitle(newPortletRegistryElement, title);
            String entityIDPrefix = this.getEntityIdPrefix(existingPortletRegistryElement);
            this.setEntityIdPrefix(newPortletRegistryElement, entityIDPrefix);
            this.setWidth(newPortletRegistryElement, "thin", null);
            this.setVisible(newPortletRegistryElement, true);
        } else if (title != null) {
            this.setPortletWindowTitle(newPortletRegistryElement, title);
        }
        this.appendDocument(newPortletRegistryElement);
    }

    @Override
    public void removePortletWindow(String portletWindowname) throws PortletRegistryException {
        PortletRegistryElement existingPortletRegistryElement = this.portletWindowRegistry.getRegistryElement(portletWindowname);
        if (existingPortletRegistryElement != null) {
            this.portletWindowRegistry.removeRegistryElement(existingPortletRegistryElement);
            this.writeDocument(this.portletWindowRegistry);
        }
    }

    @Override
    public void removePortletWindows(String portletName) throws PortletRegistryException {
        List<PortletRegistryElement> portletWindows = this.portletWindowRegistry.getRegistryElements();
        ArrayList<PortletRegistryElement> removeablePortletWindows = new ArrayList<PortletRegistryElement>();
        boolean remove = false;
        for (PortletRegistryElement portletWindow : portletWindows) {
            if (!portletWindow.getPortletName().equals(portletName)) continue;
            remove = true;
            removeablePortletWindows.add(portletWindow);
        }
        for (PortletRegistryElement portletWindow : removeablePortletWindows) {
            this.portletWindowRegistry.removeRegistryElement(portletWindow);
        }
        if (remove) {
            this.writeDocument(this.portletWindowRegistry);
        }
    }

    @Override
    public void movePortletWindows(List<PortletWindowData> portletWindows) throws PortletRegistryException {
        for (PortletWindowData portletWindow : portletWindows) {
            PortletRegistryElement element = this.portletWindowRegistry.getRegistryElement(portletWindow.getPortletWindowName());
            element.setStringProperty("width", portletWindow.getWidth());
            element.setStringProperty("row", portletWindow.getRowNumber().toString());
        }
        this.writeDocument(this.portletWindowRegistry);
    }

    private void showHidePortletWindow(String portletWindowName, String visible) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.portletWindowRegistry.getRegistryElement(portletWindowName);
        if (portletRegistryElement != null) {
            portletRegistryElement.setStringProperty("visible", visible);
            this.appendDocument(portletRegistryElement);
        }
    }

    @Override
    public void showPortletWindow(String portletWindowName, boolean visible) throws PortletRegistryException {
        this.showHidePortletWindow(portletWindowName, String.valueOf(visible));
    }

    @Override
    public String getPortletName(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String name = portletRegistryElement.getPortletName();
        return name;
    }

    @Override
    public List<String> getPortletWindows(String portletName) throws PortletRegistryException {
        List<PortletRegistryElement> portletWindows = this.portletWindowRegistry.getRegistryElements();
        ArrayList<String> list = new ArrayList<String>();
        for (PortletRegistryElement portletWindowElt : portletWindows) {
            PortletWindow portletWindow = (PortletWindow)portletWindowElt;
            if (!portletWindow.getPortletName().equals(portletName)) continue;
            list.add(portletWindow.getName());
        }
        return list;
    }

    @Override
    public Integer getRowNumber(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String rowNumber = portletRegistryElement.getStringProperty("row");
        return Integer.valueOf(rowNumber);
    }

    @Override
    public String getWidth(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String width = portletRegistryElement.getStringProperty("width");
        return width;
    }

    @Override
    public void setWidth(String portletWindowName, String width, String row) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        this.setWidth(portletRegistryElement, width, row);
        this.appendDocument(portletRegistryElement);
    }

    @Override
    public String getPortletID(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String portletId = portletRegistryElement.getStringProperty("portletID");
        return portletId;
    }

    @Override
    public String getConsumerID(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String consumerId = portletRegistryElement.getStringProperty("consumerId");
        return consumerId;
    }

    @Override
    public String getProducerEntityID(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String producerEntityId = portletRegistryElement.getStringProperty("producerEntityID");
        return producerEntityId;
    }

    @Override
    public boolean isRemote(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        boolean isRemote = false;
        if (portletRegistryElement.getRemote() != null) {
            isRemote = Boolean.valueOf(portletRegistryElement.getRemote());
        }
        return isRemote;
    }

    private PortletRegistryElement getRegistryElement(String name) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.portletWindowRegistry.getRegistryElement(name);
        if (portletRegistryElement == null) {
            throw new PortletRegistryException(name + " does not exist");
        }
        return portletRegistryElement;
    }

    private PortletRegistryWriter getPortletRegistryWriter(String context) throws PortletRegistryException {
        String registryLocation = PortletRegistryHelper.getRegistryLocation();
        return new PortletWindowRegistryWriter(registryLocation, context);
    }

    private void appendDocument(PortletRegistryElement portletRegistryElement) throws PortletRegistryException {
        PortletRegistryWriter portletWindowRegistryWriter = this.getPortletRegistryWriter(this.context);
        ArrayList<PortletRegistryElement> portletWindowElementList = new ArrayList<PortletRegistryElement>();
        portletWindowElementList.add(portletRegistryElement);
        try {
            portletWindowRegistryWriter.appendDocument(portletWindowElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }

    private void writeDocument(PortletRegistryObject portletWindowRegistry) throws PortletRegistryException {
        PortletRegistryWriter portletWindowRegistryWriter = this.getPortletRegistryWriter(this.context);
        List<PortletRegistryElement> portletWindowElementList = portletWindowRegistry.getRegistryElements();
        try {
            portletWindowRegistryWriter.writeDocument(portletWindowElementList);
        }
        catch (Exception e) {
            throw new PortletRegistryException(e);
        }
    }

    @Override
    public List<String> getRemotePortletWindows() throws PortletRegistryException {
        List<PortletRegistryElement> portletWindows = this.portletWindowRegistry.getRegistryElements();
        ArrayList<String> remotePortletWindows = new ArrayList<String>();
        for (PortletRegistryElement portletWindowObject : portletWindows) {
            PortletWindow portletWindow = (PortletWindow)portletWindowObject;
            boolean isRemote = Boolean.valueOf(portletWindow.getRemote());
            if (!isRemote) continue;
            remotePortletWindows.add(portletWindow.getName());
        }
        return remotePortletWindows;
    }

    @Override
    public PortletLang getPortletLang(String portletWindowName) throws PortletRegistryException {
        PortletRegistryElement portletRegistryElement = this.getRegistryElement(portletWindowName);
        String lang = portletRegistryElement.getLang();
        return new PortletLang(lang);
    }
}

