/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.memory;

import java.math.BigDecimal;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.util.StringUtil;

public enum MemoryUnit {
    B(1, "o", "bytes"),
    KB(2, "ko", "Kb"),
    MB(3, "mo", "Mb"),
    GB(4, "go", "Gb"),
    TB(5, "to", "Tb");

    private final String bundleKey;
    private final String bundleDefault;
    private BigDecimal limit = null;
    private final int power;
    static BigDecimal byteMultiplier;

    private MemoryUnit(int power, String bundleKey, String bundleDefault) {
        this.bundleKey = bundleKey;
        this.bundleDefault = bundleDefault;
        this.limit = null;
        this.power = power;
    }

    protected String getBundleKey() {
        return this.bundleKey;
    }

    protected String getBundleDefault() {
        return this.bundleDefault;
    }

    public String getLabel() {
        return StringUtil.defaultStringIfNotDefined((String)MemoryUnit.getStringTranslation(this.getBundleKey()), (String)this.getBundleDefault());
    }

    public String getLabel(String language) {
        return StringUtil.defaultStringIfNotDefined((String)MemoryUnit.getStringTranslation(this.getBundleKey(), language), (String)this.getBundleDefault());
    }

    public BigDecimal getLimit() {
        if (this.limit == null) {
            this.limit = byteMultiplier.pow(this.power);
        }
        return this.limit;
    }

    public int getPower() {
        return this.power;
    }

    private static String getStringTranslation(String key) {
        return MemoryUnit.getStringTranslation(key, MessageManager.getLanguage());
    }

    private static String getStringTranslation(String key, String language) {
        LocalizationBundle rl = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)language);
        return rl.getString(key);
    }

    static {
        byteMultiplier = new BigDecimal(String.valueOf(1024));
    }
}

