/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class CollectionUtil {
    private static final int SPLIT_BATCH_SIZE = 500;

    private CollectionUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> List<T> reverse(List<T> list) {
        Collections.reverse(list);
        return list;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return !CollectionUtil.isNotEmpty(collection);
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static <T> List<List<T>> splitList(List<T> collection) {
        return (List)CollectionUtil.split(collection, 500);
    }

    public static <T> Collection<Collection<T>> split(Collection<T> collection) {
        return CollectionUtil.split(collection, 500);
    }

    public static <T> Collection<Collection<T>> split(Collection<T> collection, int collectionSizeMax) {
        List<Collection<T>> result;
        if (CollectionUtil.isEmpty(collection)) {
            return new ArrayList<Collection<T>>();
        }
        try {
            if (collectionSizeMax > 0 && collection.size() > collectionSizeMax) {
                int size = collection.size() / collectionSizeMax;
                if (collection.size() % collectionSizeMax != 0) {
                    ++size;
                }
                result = new ArrayList<Collection<T>>(size);
                ArrayList<T> curLot = null;
                for (T element : collection) {
                    if (curLot == null || curLot.size() >= collectionSizeMax) {
                        curLot = new ArrayList<T>(collectionSizeMax);
                        result.add(curLot);
                    }
                    curLot.add(element);
                }
            } else {
                result = Collections.singletonList(collection);
            }
        }
        catch (Exception e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
        return result;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... values) {
        ArrayList listWithValues = new ArrayList();
        Collections.addAll(listWithValues, values);
        return listWithValues;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... values) {
        return new HashSet<T>(Arrays.asList(values));
    }

    @SafeVarargs
    public static <T> boolean addAllIgnoreNull(Collection<? super T> c, T ... elements) {
        boolean result = false;
        for (T element : elements) {
            if (element == null) continue;
            result |= c.add(element);
        }
        return result;
    }

    public static <T> List<T> union(List<T> list1, List<T> list2) {
        return new ArrayList<T>(CollectionUtil.union(list1, list2));
    }

    public static <T> Collection<T> union(Collection<T> col1, Collection<T> col2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(col1);
        set.addAll(col2);
        return set;
    }

    public static <T> List<T> intersection(List<T> list1, List<T> list2) {
        return (List)CollectionUtil.intersection(list1, list2);
    }

    public static <T> Collection<T> intersection(Collection<T> col1, Collection<T> col2) {
        return CollectionUtil.intersection(col1, col2, (T t) -> t);
    }

    public static <T> List<T> intersection(List<T> list1, List<T> list2, Function<T, Object> discriminator) {
        return (List)CollectionUtil.intersection(list1, list2, discriminator);
    }

    public static <T> Collection<T> intersection(Collection<T> col1, Collection<T> col2, Function<T, Object> discriminator) {
        Collection<T> smaller = col1;
        Collection<T> larger = col2;
        if (col1.size() > col2.size()) {
            smaller = col2;
            larger = col1;
        }
        Set matcher = smaller.stream().map(discriminator).collect(Collectors.toSet());
        Stream<Object> intersection = larger.stream().filter(o -> matcher.remove(discriminator.apply(o)));
        if (col1 instanceof Set && col2 instanceof Set) {
            return intersection.collect(Collectors.toSet());
        }
        return intersection.collect(Collectors.toList());
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate) {
        return CollectionUtil.indexOf(list, predicate, 0);
    }

    public static <T> int indexOf(List<T> list, Predicate<T> predicate, int firstIndex) {
        for (int i = firstIndex; i < list.size(); ++i) {
            T item = list.get(i);
            if (!predicate.test(item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> Optional<T> findFirst(List<T> list, Predicate<T> predicate) {
        return CollectionUtil.findFirst(list, predicate, 0);
    }

    public static <T> Optional<T> findFirst(List<T> list, Predicate<T> predicate, int firstIndex) {
        int index = CollectionUtil.indexOf(list, predicate, firstIndex);
        return index >= 0 ? Optional.ofNullable(list.get(index)) : Optional.empty();
    }

    public static <T> Optional<T> findNextRupture(RuptureContext<T> context, Predicate<T> predicate) {
        if (context.isTerminated()) {
            throw new IllegalStateException("the context of the rupture indicates that it is terminated");
        }
        if (context.lastPosition == -1 || !predicate.test(context.current)) {
            int position = CollectionUtil.indexOf(context.orderedList, predicate, context.lastPosition + 1);
            if (position >= 0) {
                context.lastPosition = position;
                context.current = context.orderedList.get(position);
            } else {
                context.lastPosition = context.orderedList.size();
                context.terminated = true;
                context.current = null;
            }
        }
        return Optional.ofNullable(context.current);
    }

    public static class RuptureContext<T> {
        private final List<T> orderedList;
        private T current = null;
        private int lastPosition = -1;
        private boolean terminated = false;

        private RuptureContext(List<T> orderedList) {
            this.orderedList = orderedList;
        }

        public static <T> RuptureContext<T> newOne(List<T> orderedList) {
            return new RuptureContext<T>(orderedList);
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public void reset() {
            this.current = null;
            this.lastPosition = -1;
            this.terminated = false;
        }
    }
}

