/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.thread;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedThreadFactory;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.thread.ManagedThreadPoolException;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.logging.SilverLogger;

@Technical
@Bean
@Singleton
public class ManagedThreadPool {
    @Resource
    private ManagedThreadFactory managedThreadFactory;

    protected ManagedThreadPool() {
    }

    public static ManagedThreadPool getPool() {
        return ServiceProvider.getService(ManagedThreadPool.class, new Annotation[0]);
    }

    public List<Thread> invoke(Runnable ... runnables) {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (Runnable runnable : runnables) {
            Thread thread = this.managedThreadFactory.newThread(runnable);
            threads.add(thread);
            thread.start();
        }
        return threads;
    }

    public void invokeAndAwaitTermination(Runnable ... runnables) throws ManagedThreadPoolException {
        this.invokeAndAwaitTermination(Arrays.asList(runnables), ExecutionConfig.defaultConfig());
    }

    public void invokeAndAwaitTermination(List<? extends Runnable> runnables) throws ManagedThreadPoolException {
        this.invokeAndAwaitTermination(runnables, ExecutionConfig.defaultConfig());
    }

    public void invokeAndAwaitTermination(List<? extends Runnable> runnables, ExecutionConfig config) throws ManagedThreadPoolException {
        this.invokeAndAwaitTermination(runnables.stream(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndAwaitTermination(Stream<? extends Runnable> runnables, ExecutionConfig config) throws ManagedThreadPoolException {
        try {
            ExecutorService executorService = this.getExecutorService(config);
            ArrayList threadExecutionResults = new ArrayList();
            try {
                threadExecutionResults.addAll(runnables.map(executorService::submit).collect(Collectors.toList()));
            }
            finally {
                executorService.shutdown();
            }
            if (config.isTimeout()) {
                boolean allRunnablesAreTerminated = executorService.awaitTermination(config.getTimeout(), config.getTimeUnit());
                if (!allRunnablesAreTerminated && !config.isRunningInBackgroundAfterTimeout()) {
                    List<Runnable> notExecutedRunnables = executorService.shutdownNow();
                    for (Runnable noExecutedRunnable : notExecutedRunnables) {
                        SilverLogger.getLogger((Object)config).error("Runnable {0} has not been processed.", new Object[]{noExecutedRunnable.getClass().getName()});
                    }
                }
            } else {
                for (Future future : threadExecutionResults) {
                    future.get();
                }
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)config).silent((Throwable)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ManagedThreadPoolException(e);
        }
    }

    public <V> Future<V> invoke(Callable<V> callable) throws InterruptedException {
        return this.invoke(callable, ExecutionConfig.defaultConfig());
    }

    public <V> Future<V> invoke(Callable<V> callable, ExecutionConfig config) throws InterruptedException {
        return this.invoke(Collections.singletonList(callable), config).get(0);
    }

    public <V> List<Future<V>> invoke(List<? extends Callable<V>> callables) throws InterruptedException {
        return this.invoke(callables, ExecutionConfig.defaultConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> List<Future<V>> invoke(List<? extends Callable<V>> callables, ExecutionConfig config) throws InterruptedException {
        boolean allRunnablesAreTerminated;
        ExecutorService executorService = this.getExecutorService(config);
        ArrayList<Future<V>> futures = new ArrayList<Future<V>>();
        try {
            for (Callable<V> callable : callables) {
                futures.add(executorService.submit(callable));
            }
        }
        finally {
            executorService.shutdown();
        }
        if (config.isTimeout() && !(allRunnablesAreTerminated = executorService.awaitTermination(config.getTimeout(), config.getTimeUnit())) && !config.isRunningInBackgroundAfterTimeout()) {
            List<Runnable> notExecutedRunnables = executorService.shutdownNow();
            for (Runnable noExecutedRunnable : notExecutedRunnables) {
                SilverLogger.getLogger((Object)config).error("Runnable {0} has not been processed.", new Object[]{noExecutedRunnable.getClass().getName()});
            }
        }
        return futures;
    }

    private ExecutorService getExecutorService(ExecutionConfig config) {
        int maxThreadPoolSize = config.getMaxThreadPoolSize();
        ExecutorService executorService = maxThreadPoolSize > 0 ? (maxThreadPoolSize == 1 ? Executors.newSingleThreadExecutor((ThreadFactory)this.managedThreadFactory) : Executors.newFixedThreadPool(maxThreadPoolSize, (ThreadFactory)this.managedThreadFactory)) : Executors.newCachedThreadPool((ThreadFactory)this.managedThreadFactory);
        return executorService;
    }

    public static class ExecutionConfig {
        private int maxThreadPoolSize = 0;
        private boolean isTimeout = false;
        private long timeout = 0L;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private boolean runInBackgroundAfterTimeout = true;

        public static ExecutionConfig maxThreadPoolSizeOf(int maxThreadPoolSize) {
            return ExecutionConfig.defaultConfig().withMaxThreadPoolSizeOf(maxThreadPoolSize);
        }

        public static ExecutionConfig timeoutOf(long timeout) {
            return ExecutionConfig.defaultConfig().withTimeoutOf(timeout);
        }

        public static ExecutionConfig defaultConfig() {
            return new ExecutionConfig();
        }

        private ExecutionConfig() {
        }

        int getMaxThreadPoolSize() {
            return this.maxThreadPoolSize;
        }

        boolean isTimeout() {
            return this.isTimeout;
        }

        long getTimeout() {
            return this.timeout;
        }

        TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public ExecutionConfig withMaxThreadPoolSizeOf(int maxThreadPoolSize) {
            this.maxThreadPoolSize = maxThreadPoolSize;
            return this;
        }

        public ExecutionConfig withTimeoutOf(long timeout) {
            return this.withTimeoutOf(timeout, TimeUnit.MILLISECONDS);
        }

        public ExecutionConfig withTimeoutOf(long timeout, TimeUnit timeUnit) {
            this.isTimeout = true;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            return this;
        }

        boolean isRunningInBackgroundAfterTimeout() {
            return this.runInBackgroundAfterTimeout;
        }

        public ExecutionConfig killThreadsAfterTimeout() {
            this.runInBackgroundAfterTimeout = false;
            return this;
        }
    }
}

