/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.template;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.template.SilverpeasStringTemplate;
import org.silverpeas.core.template.SilverpeasTemplate;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class SilverpeasTemplates {
    static final String DEFAULT_COMPONENTS_DIR;
    static final String CUSTOM_COMPONENTS_DIR;
    static final String DEFAULT_CORE_DIR;
    static final String CUSTOM_CORE_DIR;
    private static final String SEPARATOR = "/";

    private SilverpeasTemplates() {
    }

    public static boolean isComponentTemplateExist(String rootPath, String template) {
        String templateFileName = template + "_" + DisplayI18NHelper.getDefaultLanguage() + ".st";
        return Files.exists(Paths.get(DEFAULT_COMPONENTS_DIR, rootPath, templateFileName), new LinkOption[0]) || Files.exists(Paths.get(CUSTOM_COMPONENTS_DIR, rootPath, templateFileName), new LinkOption[0]);
    }

    public static SilverpeasTemplate createSilverpeasTemplate(Properties configuration) {
        return new SilverpeasStringTemplate(configuration);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnComponents() {
        return SilverpeasTemplates.createSilverpeasTemplateOnComponents(null);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnComponents(String pathSuffix) {
        Properties config = new Properties();
        config.setProperty("template.root.dir", SilverpeasTemplates.computePath(DEFAULT_COMPONENTS_DIR, pathSuffix));
        config.setProperty("template.customer.dir", SilverpeasTemplates.computePath(CUSTOM_COMPONENTS_DIR, pathSuffix));
        return SilverpeasTemplates.createSilverpeasTemplate(config);
    }

    public static SilverpeasTemplate createSilverpeasTemplateOnCore(String pathSuffix) {
        Properties config = new Properties();
        config.setProperty("template.root.dir", SilverpeasTemplates.computePath(DEFAULT_CORE_DIR, pathSuffix));
        config.setProperty("template.customer.dir", SilverpeasTemplates.computePath(CUSTOM_CORE_DIR, pathSuffix));
        return SilverpeasTemplates.createSilverpeasTemplate(config);
    }

    private static String computePath(String pathBase, String pathSuffix) {
        StringBuilder sb = new StringBuilder(pathBase);
        if (StringUtils.isNotBlank((CharSequence)pathSuffix)) {
            sb.append(SEPARATOR);
            sb.append(pathSuffix);
            sb.append(SEPARATOR);
        }
        return sb.toString().replaceAll("/+", SEPARATOR);
    }

    static {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.stringtemplate");
        DEFAULT_COMPONENTS_DIR = settings.getString("template.dir.components.default");
        CUSTOM_COMPONENTS_DIR = settings.getString("template.dir.components.custom");
        DEFAULT_CORE_DIR = settings.getString("template.dir.core.default");
        CUSTOM_CORE_DIR = settings.getString("template.dir.core.custom");
    }
}

