/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.selection;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.silverpeas.core.SilverpeasResource;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.selection.SelectionContext;
import org.silverpeas.core.selection.SelectionEntry;

public class SelectionBasket
implements Serializable {
    private static final String CACHE_KEY = "###SELECTION_BASKET###";
    private final List<SelectionEntry<SilverpeasResource>> selection = new CopyOnWriteArrayList<SelectionEntry<SilverpeasResource>>();

    public static SelectionBasket get() {
        return (SelectionBasket)CacheAccessorProvider.getSessionCacheAccessor().getCache().computeIfAbsent((Object)CACHE_KEY, SelectionBasket.class, SelectionBasket::new);
    }

    private SelectionBasket() {
    }

    public <T extends SilverpeasResource> SelectionBasket put(T resource) {
        return this.put(resource, new SelectionContext());
    }

    public <T extends SilverpeasResource> SelectionBasket put(T resource, SelectionContext context) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(context);
        SelectionEntry<T> entry = new SelectionEntry<T>(resource, context);
        int index = this.selection.indexOf(entry);
        if (index != 0) {
            if (index > 0) {
                this.selection.remove(index);
            }
            this.selection.add(0, entry);
        }
        return this;
    }

    public <T extends SilverpeasResource> Optional<SelectionEntry<T>> pop() {
        return this.removeAt(0);
    }

    public Stream<SelectionEntry<SilverpeasResource>> getSelectedResources() {
        return this.selection.stream();
    }

    public <T extends SilverpeasResource> Optional<SelectionEntry<T>> getAt(int index) {
        return index < 0 || index >= this.selection.size() ? Optional.empty() : Optional.of(this.selection.get(index));
    }

    public <T extends SilverpeasResource> Optional<SelectionEntry<T>> removeAt(int index) {
        return index < 0 || index >= this.selection.size() ? Optional.empty() : Optional.of(this.selection.remove(index));
    }

    public <T extends SilverpeasResource> void remove(T resource) {
        SelectionEntry<T> entry = new SelectionEntry<T>(resource, new SelectionContext());
        this.selection.remove(entry);
    }

    public SelectionBasket clear() {
        this.selection.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.selection.isEmpty();
    }

    public int count() {
        return this.selection.size();
    }
}

