/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.backgroundprocess.AbstractBackgroundProcessRequest;
import org.silverpeas.core.backgroundprocess.BackgroundProcessTask;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.reminder.BackgroundReminderProcess;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.reminder.ReminderRepository;
import org.silverpeas.core.scheduler.SchedulerEvent;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

@Service
@Singleton
public class ReminderProcess
implements SchedulerEventListener {
    @Inject
    private ReminderRepository repository;

    public static ReminderProcess get() {
        return ServiceProvider.getService(ReminderProcess.class, new Annotation[0]);
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) {
        String reminderId = anEvent.getJobExecutionContext().getJobName();
        Reminder reminder = (Reminder)this.repository.getById(reminderId);
        reminder.triggered();
        this.notifyUserAbout(reminder);
        if (reminder.isSchedulable()) {
            Transaction.performInOne(() -> this.repository.save(reminder));
            reminder.schedule();
        } else if (reminder.isSystemUser()) {
            Transaction.performInOne(() -> {
                this.repository.delete(new Reminder[]{reminder});
                return null;
            });
        } else {
            Transaction.performInOne(() -> this.repository.save(reminder));
        }
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        String reminderId = anEvent.getJobExecutionContext().getJobName();
        SilverLogger.getLogger((Object)this).info("The reminder {0} was correctly fired", new Object[]{reminderId});
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        String reminderId = anEvent.getJobExecutionContext().getJobName();
        if (anEvent.isExceptionThrown()) {
            Throwable throwable = anEvent.getJobThrowable();
            SilverLogger.getLogger((Object)this).error("The reminder " + reminderId + " firing failed", throwable);
        } else {
            SilverLogger.getLogger((Object)this).error("The reminder " + reminderId + " firing failed", new Object[0]);
        }
    }

    private void notifyUserAbout(Reminder reminder) {
        Reminder reminderCopy = reminder.copy();
        BackgroundProcessTask.push(new BackgroundReminderUserNotificationProcess(reminderCopy));
    }

    private static class BackgroundReminderUserNotificationProcess
    extends AbstractBackgroundProcessRequest {
        private final Reminder reminder;

        private BackgroundReminderUserNotificationProcess(Reminder reminder) {
            this.reminder = reminder;
        }

        @Override
        protected void process() {
            String fullProcessName = this.reminder.getProcessName() + "ReminderProcess";
            BackgroundReminderProcess process = (BackgroundReminderProcess)ServiceProvider.getService(fullProcessName);
            process.performWith(this.reminder);
        }
    }
}

