/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.reminder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.silverpeas.core.ApplicationService;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.NoSuchPropertyException;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.reminder.DateTimeReminder;
import org.silverpeas.core.reminder.DurationReminder;
import org.silverpeas.core.reminder.ReminderIdentifier;
import org.silverpeas.core.reminder.ReminderProcess;
import org.silverpeas.core.reminder.ReminderProcessName;
import org.silverpeas.core.reminder.ReminderRepository;
import org.silverpeas.core.scheduler.Scheduler;
import org.silverpeas.core.scheduler.SchedulerEventListener;
import org.silverpeas.core.scheduler.SchedulerProvider;
import org.silverpeas.core.scheduler.trigger.JobTrigger;
import org.silverpeas.core.util.filter.Filter;
import org.silverpeas.kernel.SilverpeasRuntimeException;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="reminderType")
@Table(name="sb_reminder")
@NamedQueries(value={@NamedQuery(name="remindersByUserId", query="select r from Reminder r where r.userId = :userId"), @NamedQuery(name="remindersByContributionId", query="select r from Reminder r where r.contributionId = :contributionId"), @NamedQuery(name="remindersByContributionIdAndUserId", query="select r from Reminder r where r.userId = :userId and r.contributionId = :contributionId")})
public abstract class Reminder
extends BasicJpaEntity<Reminder, ReminderIdentifier> {
    private static final long serialVersionUID = -7921844697973849535L;
    @Embedded
    private ContributionIdentifier contributionId;
    @Column(name="userId", nullable=false, length=40)
    private String userId;
    @Column(name="process_name", nullable=false, length=200)
    private String processName;
    @Column(name="text")
    private String text;
    @Column(name="triggered")
    private boolean triggered;
    @Column(name="trigger_datetime", nullable=false)
    private Instant triggerDateTime;
    @Column(name="trigger_prop")
    private String contributionProperty;
    @Transient
    private transient OffsetDateTime nextTriggeringDate;

    public static List<Reminder> getByContribution(ContributionIdentifier contributionId) {
        return ReminderRepository.get().findByContributionId(contributionId);
    }

    public static List<Reminder> getByUser(User user) {
        return ReminderRepository.get().findByUserId(user.getId());
    }

    public static List<Reminder> getByContributionAndUser(ContributionIdentifier contributionId, User user) {
        return ReminderRepository.get().findByContributionAndUserIds(contributionId, user.getId());
    }

    public static Reminder getById(String reminderId) {
        return (Reminder)ReminderRepository.get().getById(reminderId);
    }

    public Reminder copy() {
        Reminder copy = this.newEmptyReminder();
        copy.userId = this.userId;
        copy.contributionId = this.contributionId;
        copy.processName = this.getProcessName();
        copy.triggerDateTime = this.triggerDateTime;
        copy.text = this.text;
        copy.contributionProperty = this.contributionProperty;
        copy.nextTriggeringDate = this.nextTriggeringDate;
        copy.triggered = this.triggered;
        return copy;
    }

    private Reminder newEmptyReminder() {
        try {
            Constructor<?> constructor = this.getClass().getDeclaredConstructor(new Class[0]);
            if (!constructor.canAccess(null)) {
                constructor.trySetAccessible();
            }
            return (Reminder)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }

    protected Reminder(ContributionIdentifier contributionId, ReminderProcessName processName) {
        this.contributionId = contributionId;
        this.userId = "-1";
        this.processName = processName.asString();
    }

    protected Reminder(ContributionIdentifier contributionId, User user, ReminderProcessName processName) {
        this.contributionId = contributionId;
        this.userId = user.getId();
        this.processName = processName.asString();
    }

    protected Reminder() {
    }

    public static ReminderBuilder make(ContributionIdentifier contribution, User user) {
        return new ReminderBuilder().about(contribution).forUser(user);
    }

    public <T extends Reminder> T withText(String text) {
        this.text = text;
        return (T)this;
    }

    public ContributionIdentifier getContributionId() {
        return this.contributionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isSystemUser() {
        return "-1".equals(this.userId);
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getText() {
        return this.text;
    }

    public OffsetDateTime getScheduledDateTime() {
        return this.triggerDateTime.atOffset(ZoneOffset.UTC);
    }

    public String getContributionProperty() {
        return this.contributionProperty;
    }

    <T extends Reminder> T withContributionProperty(String temporalProperty) {
        this.contributionProperty = temporalProperty;
        return (T)this;
    }

    public boolean isScheduled() {
        return this.isScheduledWith(this.getScheduler());
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    protected void triggered() {
        this.triggered = true;
    }

    public <T extends Reminder> T schedule() {
        OffsetDateTime triggeringDateTime = this.computeTriggeringDate();
        this.checkTriggeringDate(triggeringDateTime);
        this.triggerDateTime = triggeringDateTime.toInstant();
        Scheduler scheduler = this.getScheduler();
        return (T)Transaction.performInOne(() -> {
            if (this.isPersisted() && this.isScheduledWith(scheduler)) {
                scheduler.unscheduleJob(this.getJobName());
            }
            Reminder me = ReminderRepository.get().save(this);
            JobTrigger trigger = JobTrigger.triggerAt(triggeringDateTime);
            scheduler.scheduleJob(me.getJobName(), trigger, (SchedulerEventListener)ReminderProcess.get());
            return me;
        });
    }

    public void unschedule() {
        this.unschedule(true);
    }

    void unschedule(boolean deleteReminder) {
        Scheduler scheduler = this.getScheduler();
        Transaction.performInOne(() -> {
            scheduler.unscheduleJob(this.getJobName());
            if (deleteReminder) {
                ReminderRepository.get().delete(new Reminder[]{this});
            }
            return null;
        });
    }

    public boolean isSchedulable() {
        try {
            this.nextTriggeringDate = this.computeTriggeringDate();
            return this.nextTriggeringDate != null;
        }
        catch (IllegalArgumentException | NoSuchPropertyException e) {
            return false;
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected Contribution getContribution() {
        return (Contribution)ApplicationService.getInstance(this.contributionId.getComponentInstanceId()).getContributionById(this.contributionId).orElseThrow(() -> new SilverpeasRuntimeException(SilverpeasExceptionMessages.failureOnGetting(this.contributionId.getType() + " contribution", this.contributionId.getLocalId())));
    }

    protected OffsetDateTime computeTriggeringDate() {
        if (this.nextTriggeringDate != null && !this.nextTriggeringDate.isBefore(OffsetDateTime.now())) {
            return this.nextTriggeringDate;
        }
        return null;
    }

    ZoneId getUserZoneId() {
        return this.isSystemUser() ? ZoneId.systemDefault() : User.getById(this.getUserId()).getUserPreferences().getZoneId();
    }

    OffsetDateTime applyFilterOnTemporalType(Filter<Class<?>, Object> filter, ZoneId withZoneId) {
        ZoneId platformZoneId = ZoneId.systemDefault();
        ZonedDateTime platformZonedTriggeringDate = filter.matchFirst(Date.class::isAssignableFrom, d -> ZonedDateTime.ofInstant(((Date)d).toInstant(), platformZoneId)).matchFirst(Instant.class::equals, d -> ZonedDateTime.ofInstant((Instant)d, platformZoneId)).matchFirst(OffsetDateTime.class::equals, d -> ((OffsetDateTime)d).atZoneSameInstant(platformZoneId)).matchFirst(LocalDate.class::equals, d -> ((LocalDate)d).atStartOfDay(withZoneId).withZoneSameInstant(platformZoneId)).matchFirst(LocalDateTime.class::equals, d -> ((LocalDateTime)d).atZone(platformZoneId)).matchFirst(ZonedDateTime.class::equals, d -> ((ZonedDateTime)d).withZoneSameInstant(platformZoneId)).result().orElseThrow(() -> new IllegalArgumentException("The property " + this.getContributionProperty() + " isn't a date or a date time"));
        return platformZonedTriggeringDate.toOffsetDateTime();
    }

    private String getJobName() {
        return this.getId();
    }

    private boolean isScheduledWith(Scheduler scheduler) {
        return scheduler.isJobScheduled(this.getJobName());
    }

    private Scheduler getScheduler() {
        return SchedulerProvider.getPersistentScheduler();
    }

    private void checkTriggeringDate(OffsetDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalStateException("The triggering rule is invalid: the computed triggering date is null!");
        }
    }

    public static class ReminderBuilder {
        private ContributionIdentifier contribution;
        private User user;
        private String text;

        public ReminderBuilder about(ContributionIdentifier contribution) {
            this.contribution = contribution;
            return this;
        }

        public ReminderBuilder forUser(User user) {
            this.user = user;
            return this;
        }

        public ReminderBuilder withText(String text) {
            this.text = text;
            return this;
        }

        public DurationReminder triggerBefore(int duration, TimeUnit timeUnit, String temporalProperty, ReminderProcessName processName) {
            return new DurationReminder(this.contribution, this.user, processName).withText(this.text).triggerBefore(duration, timeUnit, temporalProperty);
        }

        public DateTimeReminder triggerAt(OffsetDateTime dateTime, ReminderProcessName processName) {
            return new DateTimeReminder(this.contribution, this.user, processName).withText(this.text).triggerAt(dateTime);
        }

        public DateTimeReminder triggerFrom(String temporalProperty, ReminderProcessName processName) {
            return new DateTimeReminder(this.contribution, this.user, processName).withText(this.text).triggerFrom(temporalProperty);
        }
    }
}

