/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.jdbc.sql.setters;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.sql.setters.SqlTypedParameterSetter;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Singleton
public class SqlStatementParameterSetter {
    private Map<Class<?>, SqlTypedParameterSetter> settersByType = new HashMap();

    @PostConstruct
    void registerAll() {
        Set<SqlTypedParameterSetter> setters = ServiceProvider.getAllServices(SqlTypedParameterSetter.class, new Annotation[0]);
        for (SqlTypedParameterSetter aSetter : setters) {
            for (Class<?> type : aSetter.getSupportedTypes()) {
                this.settersByType.put(type, aSetter);
            }
        }
    }

    public void setParameter(PreparedStatement statement, int idx, Object value) throws SQLException {
        SqlTypedParameterSetter setter = this.getSetterForType(value.getClass());
        if (setter != null) {
            setter.setParameter(statement, idx, value);
        } else {
            this.setObjectIdentifier(statement, idx, value);
        }
    }

    private void setObjectIdentifier(PreparedStatement preparedStatement, int paramIndex, Object parameter) throws SQLException {
        try {
            Method idGetter = parameter.getClass().getDeclaredMethod("getId", new Class[0]);
            String id = (String)idGetter.invoke(parameter, new Object[0]);
            preparedStatement.setString(paramIndex, id);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("SQL parameter type not handled: " + String.valueOf(parameter.getClass()), e);
        }
    }

    private SqlTypedParameterSetter getSetterForType(Class<?> type) {
        Class<?> superType;
        SqlTypedParameterSetter setter = this.settersByType.get(type);
        if (setter == null && (superType = type.getSuperclass()) != null) {
            setter = this.getSetterForType(superType);
        }
        return setter;
    }
}

