/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.OperationContext;
import org.silverpeas.core.persistence.datasource.PersistenceOperation;
import org.silverpeas.core.persistence.datasource.UpdateOperation;
import org.silverpeas.core.persistence.datasource.model.Entity;
import org.silverpeas.core.persistence.datasource.model.jpa.JPA;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaEntityReflection;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.util.ArgumentAssertion;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@UpdateOperation
@Technical
@JPA
@Bean
public class JpaUpdateOperation
extends PersistenceOperation {
    private final List<SilverpeasJpaEntity<?, ?>> entities = new ArrayList();

    @Override
    protected void applyTechnicalDataTo(Entity<?, ?> entity) {
        String errorMessage = "the user identifier must exist when performing update operation";
        User user = OperationContext.getFromCache().getUser();
        ArgumentAssertion.assertTrue(Transaction.isTransactionActive(), "A transaction must be active when performing update operation");
        ArgumentAssertion.assertNotNull(user, errorMessage);
        ArgumentAssertion.assertDefined(user.getId(), errorMessage);
        if (entity instanceof SilverpeasJpaEntity) {
            SilverpeasJpaEntity jpaEntity = (SilverpeasJpaEntity)entity;
            Optional<SilverpeasJpaEntity<?, ?>> optional = this.find(jpaEntity);
            if (optional.isPresent()) {
                if (optional.get() != jpaEntity) {
                    jpaEntity.setLastUpdater(optional.get().getLastUpdater()).setLastUpdateDate(optional.get().getLastUpdateDate());
                }
            } else {
                jpaEntity.setLastUpdater(user).setLastUpdateDate(new Timestamp(new Date().getTime()));
            }
        } else {
            entity.updatedBy(user, new Timestamp(new Date().getTime()));
        }
    }

    @Override
    public void setManuallyTechnicalDataFor(Entity<?, ?> entity, User updater, Date updateDate) {
        if (entity instanceof SilverpeasJpaEntity) {
            SilverpeasJpaEntity jpaEntity = (SilverpeasJpaEntity)entity;
            JpaEntityReflection.setUpdateData(jpaEntity, updater, updateDate);
            if (this.find(jpaEntity).isEmpty()) {
                this.entities.add(jpaEntity);
            }
        }
    }

    private Optional<SilverpeasJpaEntity<?, ?>> find(Entity<?, ?> entity) {
        return this.entities.stream().filter(e -> StringUtil.isDefined((String)e.getId()) && e.equals(entity)).findFirst();
    }

    @Override
    public void clear(Entity<?, ?> entity) {
        this.entities.removeIf(e -> e.getClass().equals(entity.getClass()) && StringUtil.isDefined((String)e.getId()) && e.getId().equals(entity.getId()));
    }
}

