/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.model.identifier;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.core.persistence.datasource.model.EntityIdentifier;

@Embeddable
public class UuidIdentifier
implements EntityIdentifier {
    private static final long serialVersionUID = -5065891079478751580L;
    @Column(name="id", columnDefinition="varchar(40)", length=40)
    private String id;

    public static UuidIdentifier from(String value) {
        return new UuidIdentifier().fromString(value);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String asString() {
        return this.id;
    }

    @Override
    public UuidIdentifier fromString(String id) {
        this.id = id;
        return this;
    }

    @Override
    public UuidIdentifier generateNewId(String ... parameters) {
        this.id = UUID.randomUUID().toString();
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getId()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UuidIdentifier other = (UuidIdentifier)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public String toString() {
        return this.asString();
    }
}

