/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OrderBy {
    private final String propertyName;
    private final boolean asc;

    public static OrderBy asc(String propertyName) {
        return new OrderBy(propertyName, true);
    }

    public static OrderBy desc(String propertyName) {
        return new OrderBy(propertyName, false);
    }

    private OrderBy(String propertyName, boolean asc) {
        this.propertyName = propertyName;
        this.asc = asc;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public static void append(StringBuilder sb, OrderBy ... orderBIES) {
        OrderBy.append(sb, Arrays.asList(orderBIES));
    }

    public static void append(StringBuilder sb, List<OrderBy> orderBIES) {
        sb.append(" ORDER BY ");
        sb.append(orderBIES.stream().map(o -> o.getPropertyName() + (o.isAsc() ? " asc" : " desc")).collect(Collectors.joining(", ")));
    }
}

