/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.notification.sse.ServerEvent;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.delayed.constant.DelayedNotificationFrequency;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;

public class NotificationManagerSettings {
    private static final int DEFAULT_SSE_JOB_TRIGGER = 45;
    private static final int DEFAULT_SSE_ASYNC_TIMEOUT = 180;
    private static final int DEFAULT_SSE_STORE_EVENT_LIFETIME = 40;
    private static final int MS = 1000;
    static final SettingBundle DEFAULT_SETTINGS = ResourceLocator.getSettingBundle((String)"org.silverpeas.notificationManager.settings.notificationManagerSettings");
    static final SettingBundle DEFAULT_ICON_SETTINGS = ResourceLocator.getSettingBundle((String)"org.silverpeas.notificationserver.channel.silvermail.settings.silvermailIcons");
    private static SettingBundle settings = DEFAULT_SETTINGS;
    private static SettingBundle iconSettings = DEFAULT_ICON_SETTINGS;

    private NotificationManagerSettings() {
    }

    public static DelayedNotificationFrequency getDefaultDelayedNotificationFrequency() {
        DelayedNotificationFrequency defaultFrequency = DelayedNotificationFrequency.decode(NotificationManagerSettings.getSettings().getString("DEFAULT_DELAYED_NOTIFICATION_FREQUENCY", null));
        if (defaultFrequency == null) {
            defaultFrequency = DelayedNotificationFrequency.NONE;
        }
        return defaultFrequency;
    }

    public static Set<DelayedNotificationFrequency> getDelayedNotificationFrequencyChoiceList() {
        HashSet<DelayedNotificationFrequency> possibleFrequencies = new HashSet<DelayedNotificationFrequency>();
        String frequencyChoiceList = NotificationManagerSettings.getSettings().getString("DELAYED_NOTIFICATION_FREQUENCY_CHOICE_LIST", "").replaceAll(" +", ",");
        if (StringUtils.isNotBlank((CharSequence)frequencyChoiceList)) {
            for (String frequencyCode : frequencyChoiceList.split("[,;|]")) {
                if ("*".equals(frequencyCode)) {
                    possibleFrequencies.clear();
                    possibleFrequencies.addAll(Arrays.asList(DelayedNotificationFrequency.values()));
                    break;
                }
                possibleFrequencies.add(DelayedNotificationFrequency.decode(frequencyCode));
            }
        }
        possibleFrequencies.remove(null);
        return new TreeSet<DelayedNotificationFrequency>(possibleFrequencies);
    }

    public static boolean isUserManualNotificationRecipientLimitEnabled() {
        return NotificationManagerSettings.getUserManualNotificationRecipientLimit() > 0;
    }

    public static int getUserManualNotificationRecipientLimit() {
        return NotificationManagerSettings.getSettings().getInteger("notif.manual.receiver.limit", 0);
    }

    public static int getReceiverThresholdAfterThatReplaceUserNameListByGroupName() {
        return NotificationManagerSettings.getSettings().getInteger("notif.receiver.displayUser.threshold", 0);
    }

    public static boolean isDisplayingUserNameListInsteadOfGroupEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("notif.receiver.displayGroup", false);
    }

    public static boolean isDisplayingReceiversInNotificationMessageEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("addReceiversInBody", false);
    }

    public static String getCronOfDelayedNotificationSending() {
        return NotificationManagerSettings.getSettings().getString("cronDelayedNotificationSending", "");
    }

    public static boolean isMultiChannelNotificationEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("multiChannelNotification", false);
    }

    static List<NotifChannel> getDefaultChannels() {
        List<Object> channels;
        String defaultChannelSetting = NotificationManagerSettings.getSettings().getString("notif.defaultChannels", "");
        boolean isMultiChannelSupported = NotificationManagerSettings.isMultiChannelNotificationEnabled();
        String[] defaultChannels = defaultChannelSetting.replaceAll(" {2,}", " ").split(" ");
        Stream<NotifChannel> streamOfChannels = Stream.of(defaultChannels).map(NotifChannel::decode).filter(Optional::isPresent).map(Optional::get);
        if (!isMultiChannelSupported) {
            channels = new ArrayList<NotifChannel>(1);
            channels.add((Object)streamOfChannels.findFirst().orElse(NotifChannel.SMTP));
        } else {
            channels = streamOfChannels.distinct().collect(Collectors.toList());
        }
        if (channels.isEmpty()) {
            channels.add((Object)NotifChannel.SMTP);
        }
        return channels;
    }

    public static boolean isRemoveSenderFromSubscriptionNotificationReceiversEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.subscription.removeSenderFromReceivers.enabled", true);
    }

    public static boolean isSubscriptionNotificationConfirmationEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.subscription.confirmation.enabled", true);
    }

    public static int getSseAsyncJobTrigger() {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse.job.trigger", 45);
    }

    public static int getSseAsyncTimeout() {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse.async.timeout", 180) * 1000;
    }

    public static boolean isCheckPreviousAsyncContextEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.sse.async.previous.check", true);
    }

    public static int getSseSendMaxThreadPool() {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse.send.thread.pool.max", 0);
    }

    public static int getSseStoreEventLifeTime() {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse.store.event.lifetime", 40) * 1000;
    }

    public static boolean isSseEnabled() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.sse.enabled", true);
    }

    public static boolean usingWebSocket() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.sse.usingWebSocket", false);
    }

    public static int getWebSocketSendTimeout() {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse.websocket.send.timeout", 180000);
    }

    public static boolean isSseEnabledFor(ServerEvent serverEvent) {
        return NotificationManagerSettings.isSseEnabled() && NotificationManagerSettings.getSettings().getBoolean("notification.sse.event." + serverEvent.getName().asString() + ".enabled", true);
    }

    public static int sendEveryAmountOfSecondsFor(ServerEvent.ServerEventName serverEventName) {
        return NotificationManagerSettings.getSettings().getInteger("notification.sse." + serverEventName.asString() + ".send.every", 0);
    }

    public static String getUserNotificationDesktopIconUrl() {
        return iconSettings.getString("silvermail.desktop.url", "/util/icons/desktop-user-notification.png");
    }

    public static boolean isSpaceLabelInNotificationSource() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.source.spaceLabel");
    }

    public static boolean isComponentInstanceLabelInNotificationSource() {
        return NotificationManagerSettings.getSettings().getBoolean("notification.source.componentLabel");
    }

    static void setSettings(SettingBundle newSettings) {
        settings = newSettings;
    }

    static void setIconSettings(SettingBundle newIconSettings) {
        iconSettings = newIconSettings;
    }

    static SettingBundle getSettings() {
        return settings;
    }
}

