/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.sse;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.sse.AbstractServerEventContext;
import org.silverpeas.core.notification.sse.HeartbeatServerEvent;
import org.silverpeas.core.notification.sse.ServerEventDispatcherTask;
import org.silverpeas.core.notification.sse.SessionPreviousCheckServerEvent;
import org.silverpeas.core.notification.sse.SilverpeasServerEventContextManager;
import org.silverpeas.core.notification.sse.SseLogger;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class SilverpeasAsyncContext
extends AbstractServerEventContext<AsyncContext>
implements AsyncContext {
    private static final int CLIENT_RETRY = 5000;
    private boolean heartbeat = false;
    private boolean complete = false;
    private boolean timeout = false;
    private boolean error = false;

    SilverpeasAsyncContext(SilverpeasServerEventContextManager manager, AsyncContext wrappedInstance, String sessionId, User user) {
        super(manager, wrappedInstance, sessionId, user);
    }

    public static SilverpeasAsyncContext wrap(SilverLogger silverLogger, AsyncContext asyncContext, String userSessionId, User user) throws ServletException {
        if (asyncContext instanceof SilverpeasAsyncContext) {
            return (SilverpeasAsyncContext)asyncContext;
        }
        SilverpeasAsyncContext context = new SilverpeasAsyncContext(SilverpeasServerEventContextManager.get(), asyncContext, userSessionId, user);
        SilverpeasAsyncListener listener = context.createListener(SilverpeasAsyncListener.class).init(silverLogger, context);
        context.addListener(listener);
        return context;
    }

    @Override
    public void closeOnPreviousCheckFailure() {
        if (this.isSendPossible()) {
            this.safeWrite(() -> {
                try {
                    SseLogger.get().debug("send check to {0}", new Object[]{this});
                    SessionPreviousCheckServerEvent.createFor(this.getSessionId()).send(this, this.getSessionId(), this.getUser());
                }
                catch (Exception e) {
                    this.complete();
                }
            });
        }
    }

    @Override
    public void sendHeartbeatIfEnabled() {
        if (this.isHeartbeatBehavior()) {
            this.safeWrite(() -> {
                try {
                    SseLogger.get().debug("send heartbeat to {0}", new Object[]{this});
                    HeartbeatServerEvent.createFor(this.getSessionId()).send(this, this.getSessionId(), this.getUser());
                }
                catch (Exception e) {
                    SseLogger.get().error((Throwable)e);
                    ServerEventDispatcherTask.unregisterContext(this);
                }
            });
        }
    }

    @Override
    public void performEventSend(String name, long id, String data) throws IOException {
        int capacity = 100 + name.length() + data.length();
        StringBuilder sb = new StringBuilder(capacity);
        sb.append("retry: ").append(5000);
        sb.append("\nid: ").append(id);
        if (StringUtil.isDefined((String)name)) {
            sb.append("\nevent: ").append(name);
        }
        sb.append("\ndata: ");
        if (StringUtil.isDefined((String)data)) {
            for (int i = 0; i < data.length(); ++i) {
                char currentChar = data.charAt(i);
                if (currentChar == '\n') {
                    sb.append("\ndata: ");
                    continue;
                }
                sb.append(currentChar);
            }
        }
        sb.append("\n\n");
        PrintWriter writer = this.getResponse().getWriter();
        writer.append(sb.toString());
        writer.flush();
    }

    @Override
    public boolean isSendPossible() {
        return !this.isComplete() && !this.isTimeoutReached() && !this.hasErrorOccurred();
    }

    @Override
    public String getRequestURI() {
        return this.getRequest().getRequestURI();
    }

    public HttpServletRequest getRequest() {
        return (HttpServletRequest)((AsyncContext)this.getWrappedInstance()).getRequest();
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)((AsyncContext)this.getWrappedInstance()).getResponse();
    }

    public boolean hasOriginalRequestAndResponse() {
        return ((AsyncContext)this.getWrappedInstance()).hasOriginalRequestAndResponse();
    }

    public void dispatch() {
        ((AsyncContext)this.getWrappedInstance()).dispatch();
    }

    public void dispatch(String path) {
        ((AsyncContext)this.getWrappedInstance()).dispatch(path);
    }

    public void dispatch(ServletContext context, String path) {
        ((AsyncContext)this.getWrappedInstance()).dispatch(context, path);
    }

    public void complete() {
        this.markAsComplete(true);
    }

    private boolean isHeartbeatBehavior() {
        return this.safeRead(() -> this.heartbeat);
    }

    public void setHeartbeat(boolean heartbeat) {
        this.safeWrite(() -> {
            this.heartbeat = heartbeat;
        });
    }

    public boolean isComplete() {
        return this.safeRead(() -> this.complete);
    }

    void markAsComplete(boolean performRealComplete) {
        this.safeWrite(() -> {
            if (!this.complete) {
                this.complete = true;
                if (performRealComplete) {
                    ((AsyncContext)this.getWrappedInstance()).complete();
                }
                this.getManager().unregister(this);
            }
        });
    }

    @Override
    public void close() {
        this.complete();
    }

    boolean isTimeoutReached() {
        return this.safeRead(() -> this.timeout);
    }

    void markTimeoutAsReached() {
        this.safeWrite(() -> {
            this.timeout = true;
        });
    }

    boolean hasErrorOccurred() {
        return this.safeRead(() -> this.error);
    }

    void markAsErrorOccurred() {
        this.safeWrite(() -> {
            this.error = true;
        });
    }

    public void start(Runnable run) {
        ((AsyncContext)this.getWrappedInstance()).start(run);
    }

    public void addListener(AsyncListener listener) {
        ((AsyncContext)this.getWrappedInstance()).addListener(listener);
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        ((AsyncContext)this.getWrappedInstance()).addListener(listener, servletRequest, servletResponse);
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)((AsyncContext)this.getWrappedInstance()).createListener(clazz);
    }

    public long getTimeout() {
        return ((AsyncContext)this.getWrappedInstance()).getTimeout();
    }

    public void setTimeout(long timeout) {
        ((AsyncContext)this.getWrappedInstance()).setTimeout(timeout);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append((Object)super.toString());
        tsb.append("timeout", this.getTimeout());
        return tsb.toString();
    }

    private static class SilverpeasAsyncListener
    implements AsyncListener {
        private SilverLogger silverLogger;
        private SilverpeasAsyncContext context;

        protected SilverpeasAsyncListener() {
        }

        private SilverpeasAsyncListener init(SilverLogger silverLogger, SilverpeasAsyncContext context) {
            this.silverLogger = silverLogger;
            this.context = context;
            return this;
        }

        public void onComplete(AsyncEvent event) throws IOException {
            this.context.markAsComplete(false);
            this.silverLogger.debug("Async context is completed ({0})", new Object[]{this.context});
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            this.context.markTimeoutAsReached();
            this.silverLogger.debug("Async context is timed out ({0})", new Object[]{this.context});
            this.context.complete();
        }

        public void onError(AsyncEvent event) throws IOException {
            this.context.markAsErrorOccurred();
            this.silverLogger.debug("Async context thrown an error ({0})", new Object[]{this.context});
            this.context.markAsComplete(false);
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            this.silverLogger.debug("Async context is starting ({0})", new Object[]{this.context});
        }
    }
}

